/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotItemAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.IFixedSlotsAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FixedSlotsAssignmentProblem
implements IFixedSlotsAssignmentProblem {
    private final Map<IWorkSlot, Set<FixedSlotItemAssignmentProblem>> slotAssignmentProblems;

    FixedSlotsAssignmentProblem(Map<IWorkSlot, Set<FixedSlotItemAssignmentProblem>> slotAssignmentProblems) {
        this.slotAssignmentProblems = slotAssignmentProblems;
    }

    public static Optional<FixedSlotsAssignmentProblem> tryCreate(IRoadmapProblem problem) {
        Map<IWorkSlot, Set<FixedSlotItemAssignmentProblem>> slotAssignmentProblems = FixedSlotsAssignmentProblem.getSlotProblems(problem);
        if (slotAssignmentProblems.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)new FixedSlotsAssignmentProblem(slotAssignmentProblems));
    }

    private static Map<IWorkSlot, Set<FixedSlotItemAssignmentProblem>> getSlotProblems(IRoadmapProblem problem) {
        HashMap slotAssignmentProblems = Maps.newHashMap();
        for (IProcessingItem item : problem.getBacklog().getProcessingItems()) {
            FixedSlotItemAssignmentProblem itemProblem = (FixedSlotItemAssignmentProblem)FixedSlotItemAssignmentProblem.tryCreateForItem(item).orNull();
            if (itemProblem == null) continue;
            RmUtils.addToKeyedSets(slotAssignmentProblems, itemProblem.getWorkSlot(), itemProblem);
        }
        return slotAssignmentProblems;
    }

    @Override
    public Set<IWorkSlot> getWorkSlotsWithAssignedItems() {
        return this.slotAssignmentProblems.keySet();
    }

    @Override
    public Set<FixedSlotItemAssignmentProblem> getAssignmentProblemsForSlot(IWorkSlot workSlot) {
        return this.slotAssignmentProblems.get(workSlot);
    }
}

