/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.EpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

class CoveringEpisodeSelector {
    CoveringEpisodeSelector() {
    }

    Optional<IEpisodeSchedule> tryGetCoveringSchedule(IIntegerInterval solutionInterval, LinkedHashMap<IEpisode, Optional<Integer>> possibleEpisodesToStart, BiMap<String, IEpisodeSchedule> episodeSchedules) {
        for (Map.Entry<IEpisode, Optional<Integer>> episodeStartEntry : possibleEpisodesToStart.entrySet()) {
            IIntegerInterval episodeInterval = (IIntegerInterval)this.getEpisodeInterval(episodeStartEntry.getKey(), (IEpisodeSchedule)episodeSchedules.get((Object)episodeStartEntry.getKey().getId()), episodeStartEntry.getValue()).orNull();
            if (episodeInterval == null || !this.isContained(solutionInterval, episodeInterval)) continue;
            if (episodeSchedules.containsKey((Object)episodeStartEntry.getKey().getId())) {
                return Optional.of((Object)episodeSchedules.get((Object)episodeStartEntry.getKey().getId()));
            }
            return Optional.of((Object)EpisodeSchedule.createEmpty(episodeStartEntry.getKey(), episodeInterval.getStart()));
        }
        return Optional.absent();
    }

    private Optional<IIntegerInterval> getEpisodeInterval(IEpisode episode, @Nullable IEpisodeSchedule schedule, Optional<Integer> start) {
        Optional<Integer> end = this.tryGetEnd(episode, schedule);
        if (!end.isPresent()) {
            return Optional.absent();
        }
        if (!start.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)new IntegerInterval((Integer)start.get(), (Integer)end.get()));
    }

    private Optional<Integer> tryGetEnd(IEpisode episode, @Nullable IEpisodeSchedule schedule) {
        if (episode.getFixedEndTime().isPresent()) {
            return episode.getFixedEndTime();
        }
        if (schedule == null) {
            return Optional.absent();
        }
        return Optional.of((Object)schedule.getEnd());
    }

    private boolean isContained(IIntegerInterval solutionInterval, IIntegerInterval episodeInterval) {
        return episodeInterval.contains(solutionInterval.getStart()) && episodeInterval.contains(solutionInterval.getEnd());
    }
}

