/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotsAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.EarliestStartIgnoredWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.EpisodeStartShiftWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.TransformedGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ISingleResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IUnstructuredItem;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class TransformedUnstructuredSchedule
implements IUnstructuredItemSchedule {
    private final IUnstructuredItem item;
    private final IWorkSlot workSlot;
    private final Map<IResourceGroup, ISingleResourceGroupAssignment> map;
    private final Set<IScheduleWarning> warnings;

    TransformedUnstructuredSchedule(IUnstructuredItem item, IWorkSlot workSlot, Map<IResourceGroup, ISingleResourceGroupAssignment> map, Set<IScheduleWarning> warnings) {
        this.item = item;
        this.workSlot = workSlot;
        this.map = map;
        this.warnings = warnings;
    }

    @Override
    public Set<IResourceGroup> getInvolvedResourceGroups() {
        return this.map.keySet();
    }

    @Override
    public ISingleResourceGroupAssignment getWorkAssignmentsForGroup(IResourceGroup group) {
        return this.map.get(group);
    }

    @Override
    public Map<IProcessingStage, Set<IWorkSlot>> getStageToWorkSlotsMap() {
        HashMap stageToSlots = Maps.newHashMap();
        for (IProcessingStage stage : this.item.getSpecifiedStages()) {
            stageToSlots.put(stage, Sets.newHashSet((Object[])new IWorkSlot[]{this.workSlot}));
        }
        return stageToSlots;
    }

    @Override
    public IAggregatedWorkPackage getAggregatedWorkPackage() {
        return this.item.getWorkDemand();
    }

    @Override
    public Map<IResourceGroup, ISingleResourceGroupAssignment> getGroupAssignments() {
        return this.map;
    }

    @Override
    public boolean isItemCompleted() {
        return true;
    }

    @Override
    public Set<IScheduleWarning> getWarnings() {
        return this.warnings;
    }

    @Override
    public int getReleaseTime() {
        return this.workSlot.getStart();
    }

    @Override
    public String getId() {
        return this.item.getId();
    }

    @Override
    public int getStart() {
        return this.workSlot.getStart();
    }

    @Override
    public int getEnd() {
        return this.workSlot.getEnd();
    }

    @Override
    public int getLength() {
        return this.workSlot.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.workSlot.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.workSlot.getOverlappingInterval(interval);
    }

    @Override
    public Set<IWorkAssignment> getWorkAssignments() {
        return this.map.values().iterator().next().getWorkAssignments();
    }

    static TransformedUnstructuredSchedule create(IUnstructuredItem item, FixedSlotsAssignmentSolution fixedSlotItemsSolution, IEpisodeSchedule scheduleToIntegrate) {
        HashMap groupAssignments = Maps.newHashMap();
        groupAssignments.put(fixedSlotItemsSolution.getResourceGroup(item.getId()), TransformedGroupAssignment.create(fixedSlotItemsSolution.getWorkAssignments(item.getId()), fixedSlotItemsSolution.getWorkSlot(item.getId()), scheduleToIntegrate.getEpisode()));
        return new TransformedUnstructuredSchedule(item, fixedSlotItemsSolution.getWorkSlot(item.getId()), groupAssignments, TransformedUnstructuredSchedule.getWarnings(item, fixedSlotItemsSolution, scheduleToIntegrate));
    }

    private static Set<IScheduleWarning> getWarnings(IProcessingItem item, FixedSlotsAssignmentSolution solution, IEpisodeSchedule scheduleToIntegrate) {
        HashSet warnings = Sets.newHashSet();
        if (solution.getInterval(item.getId()).getStart() < (Integer)scheduleToIntegrate.getEpisode().getFixedStartTime().or((Object)Integer.MIN_VALUE)) {
            warnings.add(new EpisodeStartShiftWarning(item.getId()));
        }
        if (solution.getInterval(item.getId()).getStart() < item.getReleaseTime()) {
            warnings.add(new EarliestStartIgnoredWarning(item.getId()));
        }
        warnings.addAll(solution.getWarningsForItem(item.getId()));
        return warnings;
    }
}

