/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.ItemNotSchedulableViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.ResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.ResourcePoolAssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ResourceGroups;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class AssignmentTransformationResult {
    private static final Log LOGGER = Log.with(AssignmentTransformationResult.class);
    private final Optional<AssignmentRestriction> restriction;
    private final Set<IScheduleViolation> violations;
    private final Set<IScheduleWarning> warnings;
    private final boolean resourceOrAssigneeRestricted;
    private final boolean jpoTeamRestricted;

    public AssignmentTransformationResult(AssignmentRestriction assignmentRestriction, Set<IScheduleWarning> warnings, boolean resourceOrAssignee, boolean jpoTeamRestricted) {
        this.restriction = Optional.of((Object)assignmentRestriction);
        this.violations = Sets.newHashSet();
        this.warnings = warnings;
        this.resourceOrAssigneeRestricted = resourceOrAssignee;
        this.jpoTeamRestricted = jpoTeamRestricted;
    }

    public AssignmentTransformationResult(Set<IScheduleViolation> violations, Set<IScheduleWarning> warnings) {
        this.restriction = Optional.absent();
        this.violations = violations;
        this.warnings = warnings;
        this.resourceOrAssigneeRestricted = false;
        this.jpoTeamRestricted = false;
    }

    public Optional<AssignmentRestriction> getAssignmentRestriction() {
        return this.restriction;
    }

    public Set<IScheduleViolation> getViolations() {
        return this.violations;
    }

    public Set<IScheduleWarning> getWarnings() {
        return this.warnings;
    }

    public boolean isResourceOrAssigneeRestriction() {
        return this.resourceOrAssigneeRestricted;
    }

    public boolean isTeamRestricted() {
        return this.jpoTeamRestricted;
    }

    public static class Builder {
        private final String issueId;
        private Set<IResourceGroup> possibleGroups;
        private Set<IWorkResource> possibleResources;
        private Optional<String> workSlot = Optional.absent();
        private boolean resourceRestricted = false;
        private final Set<IScheduleViolation> violations = Sets.newHashSet();
        private final Set<IScheduleWarning> warnings = Sets.newHashSet();
        private boolean resourceOrAssigneeRestriction = false;
        private boolean jpoTeamRestricted = false;

        public Builder(String issueId, Set<IResourceGroup> allResourceGroups) {
            this.issueId = issueId;
            this.possibleGroups = Sets.newHashSet(allResourceGroups);
            this.possibleResources = ResourceGroups.getResources(allResourceGroups);
        }

        public AssignmentTransformationResult build() {
            LOGGER.debug("create assignment restriction", new Object[0]);
            if (!this.violations.isEmpty()) {
                LOGGER.debug("detected violations", new Object[0]);
                return new AssignmentTransformationResult(this.violations, this.warnings);
            }
            LinkedHashSet<IResourcePool> pools = this.createResourcePools();
            if (pools.isEmpty()) {
                LOGGER.debug("no assignments pools available", new Object[0]);
                return new AssignmentTransformationResult(Sets.newHashSet((Object[])new IScheduleViolation[]{new ItemNotSchedulableViolation(this.issueId)}), this.warnings);
            }
            return new AssignmentTransformationResult(this.createAssignmentRestriction(pools), this.warnings, this.resourceOrAssigneeRestriction, this.jpoTeamRestricted);
        }

        private ResourcePoolAssignmentRestriction createAssignmentRestriction(LinkedHashSet<IResourcePool> pools) {
            if (this.workSlot.isPresent()) {
                LOGGER.debug("create assignment restriction with work slot", new Object[0]);
                IResourcePool firstPool = (IResourcePool)Iterables.getFirst(pools, null);
                Optional<IWorkSlot> slot = firstPool.getResourceGroup().tryGetWorkSlotWithId((String)this.workSlot.get());
                if (!slot.isPresent()) {
                    LOGGER.warn("sprint not found for pool - assignment ignored", new Object[0]);
                } else {
                    LOGGER.debug("create restriction for group %s and index %d", firstPool.getResourceGroup().getId(), ((IWorkSlot)slot.get()).getIndex());
                    return new ResourcePoolAssignmentRestriction(Sets.newHashSet((Object[])new IResourcePool[]{firstPool}), (Optional<Integer>)Optional.of((Object)((IWorkSlot)slot.get()).getIndex()));
                }
            }
            LOGGER.debug("create restriction without slot restriction", new Object[0]);
            return new ResourcePoolAssignmentRestriction(pools);
        }

        private LinkedHashSet<IResourcePool> createResourcePools() {
            LinkedHashSet pools = Sets.newLinkedHashSet();
            for (IResourceGroup group : RmSortableUtils.sort(this.possibleGroups)) {
                HashSet selectedResources = Sets.newHashSet((Iterable)Sets.intersection(group.getResources(), this.possibleResources));
                if (selectedResources.isEmpty()) continue;
                pools.add(new ResourcePool(group, selectedResources));
            }
            return pools;
        }

        public void setWorkSlot(String slotId) {
            HashSet groupsWithoutSlot = Sets.newHashSet();
            for (IResourceGroup group : this.possibleGroups) {
                Optional<IWorkSlot> slot = group.tryGetWorkSlotWithId(slotId);
                if (slot.isPresent()) continue;
                groupsWithoutSlot.add(group);
            }
            this.possibleGroups.removeAll(groupsWithoutSlot);
            this.possibleResources.removeAll(ResourceGroups.getResources(groupsWithoutSlot));
            this.workSlot = Optional.of((Object)slotId);
        }

        public void setResourceGroup(IResourceGroup resourceGroup) {
            this.possibleGroups = Sets.newHashSet((Object[])new IResourceGroup[]{resourceGroup});
            this.possibleResources = Sets.intersection(this.possibleResources, resourceGroup.getResources());
            this.jpoTeamRestricted = true;
        }

        public void setResources(Set<IWorkResource> resources) {
            this.resourceOrAssigneeRestriction = true;
            this.possibleResources = resources;
            this.resourceRestricted = true;
        }

        public void restrictResourceGroups(Set<IResourceGroup> resourceGroups) {
            this.possibleGroups = Sets.intersection(this.possibleGroups, resourceGroups);
            this.possibleResources = Sets.intersection(this.possibleResources, ResourceGroups.getResources(resourceGroups));
            this.jpoTeamRestricted = true;
        }

        public Builder addViolation(IScheduleViolation violation) {
            this.violations.add(violation);
            return this;
        }

        public void addWarning(IScheduleWarning warning) {
            this.warnings.add(warning);
        }

        public boolean isValidAssigneeRestriction(Set<IWorkResource> associatedResources) {
            return !Sets.intersection(associatedResources, this.possibleResources).isEmpty();
        }

        public boolean isWorkSlotRestrictionValid(IWorkSlot workSlot) {
            return RmIdentifiableUtils.getIds(this.possibleGroups).contains(workSlot.getGroupId());
        }

        public Set<IResourceGroup> getPossibleGroups() {
            return Collections.unmodifiableSet(this.possibleGroups);
        }

        public boolean isResourceRestricted() {
            return this.resourceRestricted;
        }
    }
}

