/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;

abstract class BaseSingleGroupAssignmentRestriction
implements AssignmentRestriction {
    protected final IResourceGroup resourceGroup;
    private final Optional<Integer> workSlotIndex;

    BaseSingleGroupAssignmentRestriction(IResourceGroup resourceGroup) {
        this.resourceGroup = (IResourceGroup)Preconditions.checkNotNull((Object)resourceGroup);
        this.workSlotIndex = Optional.absent();
    }

    BaseSingleGroupAssignmentRestriction(int workSlotIndex, IResourceGroup resourceGroup) {
        this.resourceGroup = (IResourceGroup)Preconditions.checkNotNull((Object)resourceGroup);
        Preconditions.checkArgument((workSlotIndex >= 0 ? 1 : 0) != 0);
        this.workSlotIndex = Optional.of((Object)workSlotIndex);
    }

    @Override
    public Optional<Integer> getWorkSlotIndex() {
        return this.workSlotIndex;
    }

    @Override
    public Set<String> getResourceGroupIds() {
        return Sets.newHashSet((Object[])new String[]{this.resourceGroup.getId()});
    }

    @Override
    public Optional<AssignmentRestriction> getStageTaskResourceRestriction(String stageTaskId) {
        return Optional.absent();
    }
}

