/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.SubsetSelectionPool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

public class ResourcePoolAssignmentRestriction
implements AssignmentRestriction {
    private final Set<IResourcePool> resourcePools;
    private final Optional<Integer> workSlotIndex;
    private final Set<String> availableResourceIds;

    public ResourcePoolAssignmentRestriction(Set<IResourcePool> resourcePools, Optional<Integer> workSlotIndex) {
        this.resourcePools = resourcePools;
        this.workSlotIndex = workSlotIndex;
        this.availableResourceIds = ResourcePoolAssignmentRestriction.getResourceIds(resourcePools);
    }

    public ResourcePoolAssignmentRestriction(Set<IResourcePool> pools) {
        this(pools, (Optional<Integer>)Optional.absent());
    }

    private static Set<String> getResourceIds(Set<IResourcePool> resourcePools) {
        HashSet ids = Sets.newHashSet();
        for (IResourcePool pool : resourcePools) {
            ids.addAll(RmIdentifiableUtils.getIds(pool.getResources()));
        }
        return ids;
    }

    @Override
    public Set<IMutableResourcePool> filterMutableResourcePools(Set<IMutableResourceGroup> mutableResourceGroups) {
        HashSet pools = Sets.newHashSet();
        for (IMutableResourceGroup mutableResourceGroup : mutableResourceGroups) {
            if (!this.getResourceGroupIds().contains(mutableResourceGroup.getId())) continue;
            pools.add(new SubsetSelectionPool(mutableResourceGroup, RmIdentifiableUtils.getElementsWithIds(this.getResourceIds(), mutableResourceGroup.getMutableResources())));
        }
        return pools;
    }

    @Override
    public Set<IResourcePool> getResourcePools() {
        return this.resourcePools;
    }

    @Override
    public Optional<Integer> getWorkSlotIndex() {
        return this.workSlotIndex;
    }

    @Override
    public Set<String> getResourceGroupIds() {
        return RmIdentifiableUtils.getIds(this.resourcePools);
    }

    @Override
    public Optional<AssignmentRestriction> getStageTaskResourceRestriction(String stageTaskId) {
        return Optional.absent();
    }

    @Override
    public Set<AssignmentResource> filterResources(Set<AssignmentResource> skillRelevantResources) {
        return RmIdentifiableUtils.getElementsWithIds(this.availableResourceIds, skillRelevantResources);
    }

    @Override
    public Set<IWorkResource> getResources() {
        HashSet allResources = Sets.newHashSet();
        for (IResourcePool pool : this.resourcePools) {
            allResources.addAll(pool.getResources());
        }
        return allResources;
    }

    public Set<String> getResourceIds() {
        HashSet resourceIds = Sets.newHashSet();
        for (IResourcePool pool : this.resourcePools) {
            resourceIds.addAll(RmIdentifiableUtils.getIds(pool.getResources()));
        }
        return resourceIds;
    }
}

