/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.google.common.base.Optional;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ResourceGroup
implements IResourceGroup {
    private final String id;
    private final Set<IWorkResource> workResource;
    private final ImmutableNonEmptyPositivePrimitivesMap<IResourceType> resourceTypeSupply;
    private final WorkSlotsDefinition workSlotDefinition;
    private final Map<IResourceType, Set<IWorkResource>> typeToResourceMap;
    private final String title;
    private final String sortKey;
    private final boolean strictStageDivision;

    public ResourceGroup(String id, Set<IWorkResource> workResources, ImmutableNonEmptyPositivePrimitivesMap<IResourceType> resourceTypeSupply, WorkSlotsDefinition workSlotDefinition, Map<IResourceType, Set<IWorkResource>> typeToResourceMap, String title, String sortKey, boolean strictStageDivision) {
        this.id = id;
        this.workResource = Collections.unmodifiableSet(workResources);
        this.resourceTypeSupply = resourceTypeSupply;
        this.workSlotDefinition = workSlotDefinition;
        this.typeToResourceMap = Collections.unmodifiableMap(typeToResourceMap);
        this.title = title;
        this.sortKey = sortKey;
        this.strictStageDivision = strictStageDivision;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Set<IWorkResource> getResources() {
        return this.workResource;
    }

    @Override
    public boolean isStrictStageDivision() {
        return this.strictStageDivision;
    }

    @Override
    public boolean containsResourceWithId(String resourceId) {
        for (IWorkResource resource : this.workResource) {
            if (!resource.getId().equals(resourceId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return this.resourceTypeSupply.keySet();
    }

    @Override
    public ImmutableNonEmptyPositivePrimitivesMap<IResourceType> getResourceTypeSupply() {
        return this.resourceTypeSupply;
    }

    @Override
    public Map<IResourceType, Set<IWorkResource>> getTypeToResourceMap() {
        return this.typeToResourceMap;
    }

    @Override
    public IWorkSlot getNextValidWorkSlotForReleaseTime(int releaseTime) {
        return this.workSlotDefinition.getNextValidWorkSlotForReleaseTime(releaseTime);
    }

    @Override
    public IWorkSlot getNextWorkSlot(IWorkSlot workSlot) {
        return this.workSlotDefinition.getNextWorkSlot(workSlot);
    }

    @Override
    public IWorkSlot getWorkSlotWithIndex(int slotIndex) {
        return this.workSlotDefinition.getWorkSlotWithIndex(slotIndex);
    }

    @Override
    public List<IWorkSlot> getWorkSlotsBetween(int startTime, int endTime) {
        return this.workSlotDefinition.getWorkSlotsBetween(startTime, endTime);
    }

    @Override
    public boolean isWorkSlotStrict() {
        return this.workSlotDefinition.isWorkSlotStrict();
    }

    @Override
    public IWorkSlot getNextWorkSlotWithFullPresence(int timeStep) {
        return this.workSlotDefinition.getNextWorkSlotWithFullPresence(timeStep);
    }

    @Override
    public String getSortKey() {
        return this.sortKey;
    }

    @Override
    public int getStartTimeStep(int slotIndex) {
        return this.workSlotDefinition.getStartTimeStep(slotIndex);
    }

    @Override
    public int getEndTimeStep(int slotIndex) {
        return this.workSlotDefinition.getEndTimeStep(slotIndex);
    }

    @Override
    public int getDefaultSlotLength() {
        return this.workSlotDefinition.getDefaultSlotLength();
    }

    @Override
    public Optional<IWorkSlot> tryGetWorkSlotWithId(String slotId) {
        return this.workSlotDefinition.tryGetWorkSlotWithId(slotId);
    }

    @Override
    public IWorkSlot getSlotOrNextForTimeStep(int timeStep) {
        return this.workSlotDefinition.getSlotOrNextForTimeStep(timeStep);
    }

    @Override
    public boolean isRestrictedWorkSlot(int slotIndex) {
        return this.workSlotDefinition.isRestrictedWorkSlot(slotIndex);
    }

    public String toString() {
        return "ResourceGroup [id=" + this.id + ", title=" + this.title + "]";
    }
}

