/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.EmptyNonWorkingDays;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IsWorkTimeStep;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WeeklyWorkDayDefinition;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IUnboundedStepFunction;

public class TimeStepPresenceFunction
implements IUnboundedStepFunction<Boolean> {
    private final WeeklyWorkDayDefinition weeklyWorkDayFunction;
    private final IsWorkTimeStep isWorkingDayFunction;
    private float hoursPerDay;

    public TimeStepPresenceFunction(WeeklyWorkDayDefinition weeklyWorkDayFunction, float hoursPerDay) {
        this(weeklyWorkDayFunction, EmptyNonWorkingDays.INSTANCE, hoursPerDay);
    }

    public TimeStepPresenceFunction(WeeklyWorkDayDefinition weeklyWorkDayFunction, IsWorkTimeStep isWorkingDayFunction, float hoursPerDay) {
        this.weeklyWorkDayFunction = weeklyWorkDayFunction;
        this.isWorkingDayFunction = isWorkingDayFunction;
        this.hoursPerDay = hoursPerDay;
    }

    @Override
    public int getLowerSpecificationBound() {
        return Integer.MIN_VALUE;
    }

    @Override
    public Boolean getAt(int timeStep) {
        return this.weeklyWorkDayFunction.isWorkTimeStep(timeStep) && this.isWorkingDayFunction.isWorkTimeStep(timeStep);
    }

    public boolean isWorkTimeStep(int timeStep) {
        return this.getAt(timeStep);
    }

    public int getPresenceSum(IIntegerInterval interval) {
        int sum = 0;
        for (int i = interval.getStart(); i <= interval.getEnd(); ++i) {
            if (!this.getAt(i).booleanValue()) continue;
            ++sum;
        }
        return sum;
    }

    public int getWeeklyWorkDays() {
        return this.weeklyWorkDayFunction.getWorkDaysPerWeek();
    }

    public boolean isAllDisabled() {
        return this.getWeeklyWorkDays() == 0;
    }

    public float getDefaultWeeklyHours() {
        return (float)this.getWeeklyWorkDays() * this.hoursPerDay;
    }

    public float getDefaultDailyHours() {
        return this.hoursPerDay;
    }
}

