/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ProcessingDefinition
implements IProcessingDefinition {
    private final List<IProcessingStage> processingStages;
    private final int maxResourcesPerStage;
    private final float minLoadPerSprint;
    private final boolean stageTransitionEnforced;
    private final boolean syncDependeeStartEnabled;
    private final int planningHorizon;

    public ProcessingDefinition(List<IProcessingStage> processingStages, int maxResourcesPerStage, float minLoadPerSprint, boolean stageTransitionEnforced, boolean syncDependeeStartEnabled, int planningHorizon) {
        Preconditions.checkNotNull(processingStages, (Object)"stage list must not be null");
        Preconditions.checkArgument((!processingStages.isEmpty() ? 1 : 0) != 0, (Object)"stage list must not be empty");
        Preconditions.checkArgument((planningHorizon >= 0 ? 1 : 0) != 0, (Object)"planning horizon must not be negative");
        this.processingStages = Collections.unmodifiableList(processingStages);
        this.maxResourcesPerStage = maxResourcesPerStage;
        this.minLoadPerSprint = minLoadPerSprint;
        this.stageTransitionEnforced = stageTransitionEnforced;
        this.syncDependeeStartEnabled = syncDependeeStartEnabled;
        this.planningHorizon = planningHorizon;
    }

    @Override
    public List<IProcessingStage> getProcessingStages() {
        return this.processingStages;
    }

    @Override
    public int getMaxResourcesPerStage() {
        return this.maxResourcesPerStage;
    }

    @Override
    public float getMinLoadPerSprint() {
        return this.minLoadPerSprint;
    }

    @Override
    public boolean isStageTransitionEnforced() {
        return this.stageTransitionEnforced;
    }

    @Override
    public boolean isSyncDependeeStartEnabled() {
        return this.syncDependeeStartEnabled;
    }

    @Override
    public boolean isPullRequirementsUp() {
        return false;
    }

    @Override
    public int getPlanningHorizon() {
        return this.planningHorizon;
    }

    public String toString() {
        return "ProcessingDefinition [processingStages=" + Joiner.on((String)",").join(this.processingStages) + ", maxResourcesPerStage=" + this.maxResourcesPerStage + ", minLoadPerSprint=" + this.minLoadPerSprint + ", stageTransitionEnforced=" + this.stageTransitionEnforced + ", planningHorizon= " + this.planningHorizon + "]";
    }
}

