/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IStepWiseResourceAvailability;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IStepWiseResourcePresence;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;

public class StepWiseWorkSlotFunction
implements IWorkSlotFunction {
    private final IStepWiseResourcePresence presence;
    private final IStepWiseResourceAvailability availability;
    private final WorkSlotsDefinition workSlotsDefinition;
    private final ConcurrentMap<Integer, Float> slotAvailabilityCache = Maps.newConcurrentMap();

    public StepWiseWorkSlotFunction(IStepWiseResourcePresence presence, IStepWiseResourceAvailability availability, WorkSlotsDefinition workSlotsDefinition) {
        this.presence = presence;
        this.availability = availability;
        this.workSlotsDefinition = workSlotsDefinition;
    }

    @Override
    public float getUnassignedWorkInWorkSlot(int slotIndex) {
        if (this.workSlotsDefinition.isRestrictedWorkSlot(slotIndex)) {
            return 0.0f;
        }
        return this.getRestrictedAvailability(slotIndex);
    }

    @Override
    public float getRestrictedAvailability(int slotIndex) {
        Float amount = (Float)this.slotAvailabilityCache.get(slotIndex);
        if (amount != null) {
            return amount.floatValue();
        }
        amount = Float.valueOf(0.0f);
        int startTimeStep = this.workSlotsDefinition.getStartTimeStep(slotIndex);
        int endTimeStep = this.workSlotsDefinition.getEndTimeStep(slotIndex);
        for (int i = startTimeStep; i <= endTimeStep; ++i) {
            if (!this.presence.isPresent(i)) continue;
            amount = Float.valueOf(amount.floatValue() + this.availability.getAvailability(i));
        }
        this.slotAvailabilityCache.put(slotIndex, amount);
        return amount.floatValue();
    }

    @Override
    public int getFirstRegularTimeStep() {
        return Math.max(this.presence.getFirstRegularTimeStep(), this.availability.getFirstRegularTimeStep());
    }

    @Override
    public boolean isPositiveEnding() {
        return this.presence.isPositiveEnding() && this.availability.isPositiveEnding();
    }
}

