/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.ProcessingStageComparator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ISingleResourceGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositiveTroveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class AggregatedWorkPackage
implements IAggregatedWorkPackage {
    private static final Log LOGGER = Log.with(AggregatedWorkPackage.class);
    private final LinkedHashMap<IProcessingStage, IProcessingStageWorkPackage> stageToWorkDemandMap;
    private final ImmutableNonEmptyPositivePrimitivesMap<IResourceType> positiveTypeAmounts;

    AggregatedWorkPackage(LinkedHashMap<IProcessingStage, IProcessingStageWorkPackage> stageToWorkDemandMap, ImmutableNonEmptyPositivePrimitivesMap<IResourceType> positiveTypeAmounts) {
        this.stageToWorkDemandMap = stageToWorkDemandMap;
        this.positiveTypeAmounts = positiveTypeAmounts;
    }

    @Override
    public Optional<IProcessingStageWorkPackage> getWorkPackageForStage(IProcessingStage stage) {
        return Optional.fromNullable((Object)this.stageToWorkDemandMap.get(stage));
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return this.positiveTypeAmounts.keySet();
    }

    @Override
    public List<IProcessingStage> getSpecifiedStages() {
        return Lists.newArrayList(this.stageToWorkDemandMap.keySet());
    }

    public ImmutableNonEmptyPositivePrimitivesMap<IResourceType> getPositiveTypeAmounts() {
        return this.positiveTypeAmounts;
    }

    @Override
    public Optional<IProcessingStage> getPreviousStage(IProcessingStage stage) {
        ArrayList stages = Lists.newArrayList(this.stageToWorkDemandMap.keySet());
        int stageIndex = stages.indexOf(stage);
        if (stageIndex <= 0) {
            return Optional.absent();
        }
        return Optional.of(stages.get(stageIndex - 1));
    }

    @Override
    public Optional<IProcessingStage> getNextStage(IProcessingStage stage) {
        ArrayList stages = Lists.newArrayList(this.stageToWorkDemandMap.keySet());
        int stageIndex = stages.indexOf(stage);
        if (stageIndex == -1 || stageIndex >= stages.size() - 1) {
            return Optional.absent();
        }
        return Optional.of(stages.get(stageIndex + 1));
    }

    @Override
    public float getDemand() {
        return this.positiveTypeAmounts.getValueSum();
    }

    public String toString() {
        return "AggregatedWorkPackage [stageToWorkDemandMap=" + RmUtils.toString(this.stageToWorkDemandMap) + "]";
    }

    public final int hashCode() {
        return new HashCodeBuilder().append(this.stageToWorkDemandMap).toHashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatedWorkPackage)) {
            return false;
        }
        AggregatedWorkPackage other = (AggregatedWorkPackage)obj;
        return new EqualsBuilder().append(this.stageToWorkDemandMap, other.stageToWorkDemandMap).isEquals();
    }

    public static Optional<IAggregatedWorkPackage> tryCreateInstance(LinkedHashMap<IProcessingStage, IProcessingStageWorkPackage> stageToWorkDemandMap) {
        LogUtil.debug(LOGGER, "create instance for stage demand: %s", RmUtils.toString(stageToWorkDemandMap));
        if (stageToWorkDemandMap.isEmpty()) {
            LogUtil.debug(LOGGER, "empty demand map");
            return Optional.absent();
        }
        AggregatedWorkPackage instance = new AggregatedWorkPackage(stageToWorkDemandMap, AggregatedWorkPackage.init(stageToWorkDemandMap));
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return Optional.of((Object)instance);
    }

    public static Optional<IAggregatedWorkPackage> tryCreateInstanceFromActivities(List<IActivity> activities) {
        Preconditions.checkNotNull(activities, (Object)"activities must not be null");
        LogUtil.debugCollection(LOGGER, "create aggregated work package from activities: %s", activities);
        if (activities.isEmpty()) {
            return Optional.absent();
        }
        LinkedHashMap stageToWorkDemandMap = Maps.newLinkedHashMap();
        for (IActivity activity : activities) {
            stageToWorkDemandMap.put(activity.getProcessingStage(), activity);
        }
        return AggregatedWorkPackage.tryCreateInstance(stageToWorkDemandMap);
    }

    public static Optional<IAggregatedWorkPackage> tryCreateInstance(Collection<ISingleResourceGroupAssignment> groupAssignments) {
        LogUtil.debugCollection(LOGGER, "create instance from group assignments: %s", groupAssignments);
        if (groupAssignments.isEmpty()) {
            return Optional.absent();
        }
        TreeMap sumMap = Maps.newTreeMap((Comparator)new ProcessingStageComparator());
        for (ISingleResourceGroupAssignment groupAssignment : groupAssignments) {
            Set<IWorkAssignment> workAssignments = groupAssignment.getWorkAssignments();
            for (IWorkAssignment assignment : workAssignments) {
                IProcessingStage stage = assignment.getProcessingStage();
                if (!sumMap.containsKey(stage)) {
                    MutablePositivePrimitivesMap empty = RmCollectionUtils.newMutablePositiveMap();
                    sumMap.put(stage, empty);
                }
                float amount = assignment.getAssignedWorkUnits();
                IResourceType resourceType = assignment.getResourceType();
                MutablePositivePrimitivesMap stageMap = (MutablePositivePrimitivesMap)sumMap.get(stage);
                stageMap.add(resourceType, amount);
            }
        }
        LinkedHashMap stageDemands = Maps.newLinkedHashMap();
        for (Map.Entry demandEntry : sumMap.entrySet()) {
            Optional<IProcessingStageWorkPackage> stagePackage = ProcessingStageWorkPackage.tryCreateFromDemandMap((IProcessingStage)demandEntry.getKey(), (PositivePrimitivesMap)demandEntry.getValue());
            if (!stagePackage.isPresent()) continue;
            stageDemands.put(demandEntry.getKey(), stagePackage.get());
        }
        return AggregatedWorkPackage.tryCreateInstance(stageDemands);
    }

    private static ImmutableNonEmptyPositivePrimitivesMap<IResourceType> init(LinkedHashMap<IProcessingStage, IProcessingStageWorkPackage> stageToWorkDemandMap) {
        MutablePositivePrimitivesMap<IResourceType> allDemands = RmCollectionUtils.newMutablePositiveMap();
        for (IProcessingStageWorkPackage stageEntry : stageToWorkDemandMap.values()) {
            allDemands.add(stageEntry.getPositiveTypeAmounts());
        }
        return (ImmutableNonEmptyPositivePrimitivesMap)ImmutableNonEmptyPositiveTroveMap.tryCreate(allDemands).get();
    }
}

