/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math;

import com.atlassian.rm.jpo.scheduling.calculation.CancellationState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentProblemSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentProblemSolutionImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.BoundAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.BoundAssignmentProblemSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.DefaultStateTransition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.JitFringe;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.LevelWiseExhaustingQueueCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.SamplingQueueCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidateSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentFringe;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.DefaultSearchBasedSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.SearchBasedSolver;
import com.google.common.base.Optional;

public class BoundedAssignmentProblemSolver
implements BoundAssignmentProblemSolver {
    private final int maxTestAssignments;
    private final SearchBasedSolver searchBasedSolver;
    private final SamplingQueueCreator samplingQueueCreator;

    public BoundedAssignmentProblemSolver(int maxTestAssignments, CancellationState cancellationState) {
        this(maxTestAssignments, new DefaultSearchBasedSolver(cancellationState), new SamplingQueueCreator());
    }

    BoundedAssignmentProblemSolver(int maxTestAssignments, DefaultSearchBasedSolver searchBasedSolver, SamplingQueueCreator samplingQueueCreator) {
        this.maxTestAssignments = maxTestAssignments;
        this.searchBasedSolver = searchBasedSolver;
        this.samplingQueueCreator = samplingQueueCreator;
    }

    @Override
    public Optional<AssignmentProblemSolution> trySolve(BoundAssignmentProblem problem) throws InterruptedException {
        AssignmentFringe fringe = this.chooseFringe(problem);
        Optional<AssignmentCandidateSolution> solution = this.searchBasedSolver.tryFindSolution(fringe);
        if (!solution.isPresent()) {
            return Optional.absent();
        }
        AssignmentProblemSolutionImpl assignmentSolution = AssignmentProblemSolutionImpl.create((AssignmentCandidateSolution)solution.get(), problem);
        return Optional.of((Object)assignmentSolution);
    }

    private AssignmentFringe chooseFringe(BoundAssignmentProblem problem) throws InterruptedException {
        if (problem.getCombinatorialCount() > this.maxTestAssignments) {
            return new JitFringe(this.samplingQueueCreator.createPriorityQueue(problem, this.maxTestAssignments), DefaultStateTransition.createInstance(problem));
        }
        return new JitFringe(LevelWiseExhaustingQueueCreator.initializeQueue(problem), DefaultStateTransition.createInstance(problem));
    }
}

