/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.utils;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.gson.annotations.Expose;
import com.radiantminds.plugins.jira.utils.RecentlyVisitedPlan;

public class GsonRecentlyVisitedPlan {
    @Expose
    private Long planId;
    @Expose
    private Long scenarioId;
    @Expose
    private Integer jpoVersion;
    public static Function<RecentlyVisitedPlan, GsonRecentlyVisitedPlan> TRANSFORMATION = new Function<RecentlyVisitedPlan, GsonRecentlyVisitedPlan>(){

        public GsonRecentlyVisitedPlan apply(RecentlyVisitedPlan visitedItem) {
            return GsonRecentlyVisitedPlan.from(visitedItem);
        }
    };

    @Deprecated
    public GsonRecentlyVisitedPlan() {
    }

    public GsonRecentlyVisitedPlan(Long planId, Long scenarioId, Integer jpoVersion) {
        this.planId = planId;
        this.scenarioId = scenarioId;
        this.jpoVersion = jpoVersion;
    }

    public static GsonRecentlyVisitedPlan from(RecentlyVisitedPlan visitedItem) {
        return new GsonRecentlyVisitedPlan(visitedItem.getPlanId(), (Long)visitedItem.getScenarioId().orNull(), visitedItem.getJpoVersion());
    }

    public RecentlyVisitedPlan to() {
        Optional scenarioId = Optional.fromNullable((Object)this.getScenarioId());
        return new RecentlyVisitedPlan(this.getPlanId(), (Optional<Long>)scenarioId, this.getJpoVersion());
    }

    public Long getPlanId() {
        return this.planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Long getScenarioId() {
        return this.scenarioId;
    }

    public void setScenarioId(Long scenarioId) {
        this.scenarioId = scenarioId;
    }

    public Integer getJpoVersion() {
        return this.jpoVersion;
    }

    public void setJpoVersion(Integer jpoVersion) {
        this.jpoVersion = jpoVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GsonRecentlyVisitedPlan that = (GsonRecentlyVisitedPlan)o;
        if (this.planId != null ? !this.planId.equals(that.planId) : that.planId != null) {
            return false;
        }
        return this.jpoVersion != null ? this.jpoVersion.equals(that.jpoVersion) : that.jpoVersion == null;
    }

    public int hashCode() {
        int result = this.planId != null ? this.planId.hashCode() : 0;
        result = 31 * result + (this.jpoVersion != null ? this.jpoVersion.hashCode() : 0);
        return result;
    }
}

