/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.utils;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.radiantminds.plugins.jira.utils.GsonRecentlyVisitedPlan;
import com.radiantminds.plugins.jira.utils.RecentlyVisitedPlan;
import com.radiantminds.plugins.jira.utils.UserPropertyManagerWrapper;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class RecentPlansProvider {
    private static final Log LOGGER = Log.with(RecentPlansProvider.class);
    private static final int JPO_CLASSIC_PLAN = 1;
    private static final int JPO_LIVE_PLAN = 2;
    private static final Gson GSON = new Gson();
    static final String USER_PROPERTY_KEY_OBSOLETE = "com.radiantminds.roadmaps-jira.plans.recent";
    static final String USER_PROPERTY_KEY_JSON = "com.radiantminds.roadmaps-jira.plans.recent.json";
    private static final int LIMIT = 10;
    private PortfolioPlanPersistence planPersistency;
    private UserPropertyManagerWrapper userPropertyManagerWrapper;

    public RecentPlansProvider(PortfolioPlanPersistence planPersistency, UserPropertyManagerWrapper userPropertyManagerWrapper) {
        this.planPersistency = planPersistency;
        this.userPropertyManagerWrapper = userPropertyManagerWrapper;
    }

    public List<RecentlyVisitedPlan> add(long planId) throws Exception {
        ArrayList recentViewed = this.getRecentlyVisitedPlans();
        RecentlyVisitedPlan recent = new RecentlyVisitedPlan(planId, 1);
        recentViewed = this.filterExistingPlans(recentViewed);
        while (recentViewed.remove(recent)) {
        }
        recentViewed.add(0, (RecentlyVisitedPlan)recent);
        recentViewed = Lists.newArrayList((Iterable)Iterables.limit(recentViewed, (int)10));
        Iterable jsonsRecent = Iterables.transform((Iterable)recentViewed, (Function)new Function<RecentlyVisitedPlan, String>(){

            public String apply(@Nullable RecentlyVisitedPlan input) {
                return GSON.toJson(GsonRecentlyVisitedPlan.from(input));
            }
        });
        this.userPropertyManagerWrapper.setStrings(USER_PROPERTY_KEY_JSON, jsonsRecent);
        return recentViewed;
    }

    public List<RecentlyVisitedPlan> getRecentlyVisitedPlans() {
        List<String> jsonPlans = this.userPropertyManagerWrapper.getStrings(USER_PROPERTY_KEY_JSON);
        if (!jsonPlans.isEmpty()) {
            return RecentPlansProvider.parseJsonData(jsonPlans);
        }
        List<String> obsoleteData = this.userPropertyManagerWrapper.getStrings(USER_PROPERTY_KEY_OBSOLETE);
        return RecentPlansProvider.parseObsoleteData(obsoleteData);
    }

    private static List<RecentlyVisitedPlan> parseObsoleteData(List<String> obsoleteData) {
        ArrayList parsedPlans = Lists.newArrayList();
        for (String planString : obsoleteData) {
            try {
                parsedPlans.add(GSON.fromJson(planString, GsonRecentlyVisitedPlan.class).to());
            }
            catch (Exception e) {
                LOGGER.debug("recent plan string not json parsable: %s", planString);
            }
        }
        if (!parsedPlans.isEmpty()) {
            return parsedPlans;
        }
        for (String planString : obsoleteData) {
            try {
                parsedPlans.add(RecentPlansProvider.parseObsoleteData(planString));
            }
            catch (Exception e) {
                LOGGER.errorDebug(e, "Error trying to parse the obsolete data pattern!", new Object[0]);
            }
        }
        return parsedPlans;
    }

    private static List<RecentlyVisitedPlan> parseJsonData(List<String> jsonsData) {
        ArrayList legacyRecentlyVisitedPlans = Lists.newArrayList();
        for (String jsonFormat : jsonsData) {
            try {
                legacyRecentlyVisitedPlans.add(GSON.fromJson(jsonFormat, GsonRecentlyVisitedPlan.class).to());
            }
            catch (Exception e) {
                LOGGER.errorDebug(e, "Error trying to parse the json for recently visited plans!", new Object[0]);
            }
        }
        return legacyRecentlyVisitedPlans;
    }

    private static RecentlyVisitedPlan parseObsoleteData(String input) {
        String[] idParts = input.split("-");
        if (idParts.length > 1) {
            return new RecentlyVisitedPlan(Long.parseLong(idParts[0]), 2);
        }
        return new RecentlyVisitedPlan(Long.parseLong(idParts[0]), 1);
    }

    private List<RecentlyVisitedPlan> filterExistingPlans(List<RecentlyVisitedPlan> recentPlans) throws Exception {
        final List<String> allPlans = this.planPersistency.listAllAvailablePlanIds();
        return Lists.newArrayList((Iterable)Iterables.filter(recentPlans, (Predicate)new Predicate<RecentlyVisitedPlan>(){

            public boolean apply(@Nullable RecentlyVisitedPlan input) {
                return input.getJpoVersion().equals(2) || allPlans.contains(input.getPlanId() + "");
            }
        }));
    }
}

