/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.activeobjects;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsAccessor;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOTransformer;
import com.radiantminds.roadmap.common.data.persistence.ao.common.Cascade;
import com.radiantminds.roadmap.common.data.persistence.ao.common.CustomCascade;
import com.radiantminds.roadmap.common.data.persistence.ao.common.DBResetSQL;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.java.ao.OneToMany;
import net.java.ao.OneToOne;

public class ActiveObjectsUtilitiesImpl
implements ActiveObjectsUtilities {
    private static final Log LOGGER = Log.with(ActiveObjectsUtilitiesImpl.class);
    private final ActiveObjectsAccessor accessor;
    private final PersistenceIndex persistenceIndex;

    public ActiveObjectsUtilitiesImpl(ActiveObjectsAccessor accessor, PersistenceIndex persistenceIndex) {
        this.accessor = accessor;
        this.persistenceIndex = persistenceIndex;
    }

    @Override
    public final <EntityType extends IIdentifiable, AOEntityType extends AOIdentifiable> EntityType persist(Class<EntityType> entityClazz, Class<AOEntityType> aoClazz, EntityType entity, AOTransformer transformer, boolean silent) throws PersistenceException {
        if (entity == null) {
            return (EntityType)this.accessor.create(aoClazz);
        }
        AOIdentifiable aoEntity = null;
        if (aoClazz.isInstance(entity)) {
            aoEntity = (AOIdentifiable)entity;
        } else {
            if (entity.getId() != null) {
                aoEntity = this.accessor.get(aoClazz, ActiveObjectsUtilitiesImpl.convertIdentifier(entity.getId()));
                if (aoEntity == null) {
                    aoEntity = this.accessor.create(aoClazz, ActiveObjectsUtilitiesImpl.convertIdentifier(entity.getId()));
                }
            } else {
                aoEntity = this.accessor.create(aoClazz);
            }
            try {
                transformer.copyValues(entity, aoEntity);
            }
            catch (Exception ex) {
                throw new PersistenceException("Transformer failed.", ex);
            }
        }
        aoEntity.save();
        this.accessor.flush();
        return (EntityType)aoEntity;
    }

    @Override
    public <EntityType extends IIdentifiable, AOEntityType extends AOIdentifiable> EntityType create(Class<AOEntityType> clazz) {
        return (EntityType)this.accessor.create(clazz);
    }

    @Override
    public <EntityType extends IIdentifiable, AOEntityType extends AOIdentifiable> EntityType get(Class<AOEntityType> clazz, String id) throws PersistenceException {
        return this.get(clazz, ActiveObjectsUtilitiesImpl.convertIdentifier(id));
    }

    @Override
    public <EntityType extends IIdentifiable, AOEntityType extends AOIdentifiable> EntityType get(Class<AOEntityType> clazz, int id) throws PersistenceException {
        this.accessor.flush();
        return (EntityType)this.accessor.get(clazz, id);
    }

    @Override
    public <EntityType extends IIdentifiable, AOEntityType extends AOIdentifiable> boolean delete(Class<EntityType> entityClazz, Class<AOEntityType> clazz, String id) throws PersistenceException {
        AOEntityType entity = this.accessor.get(clazz, ActiveObjectsUtilitiesImpl.convertIdentifier(id));
        this.cascadeDeleteOneToManyRelations(entityClazz, clazz, entity);
        boolean retVal = this.accessor.delete(clazz, entity);
        return retVal;
    }

    @Override
    public <EntityType extends IIdentifiable, AOEntityType extends AOIdentifiable> List<EntityType> find(Class<AOEntityType> clazz) throws PersistenceException {
        AOIdentifiable[] list = this.accessor.find(clazz);
        ArrayList retVal = Lists.newArrayList();
        for (AOIdentifiable item : list) {
            retVal.add(item);
        }
        return retVal;
    }

    @Override
    public <EntityType extends IIdentifiable, AOEntityType extends AOIdentifiable> List<EntityType> find(Class<AOEntityType> clazz, String whereClause, Object ... parameters) throws PersistenceException {
        AOIdentifiable[] list = this.accessor.find(clazz, whereClause, parameters);
        ArrayList retVal = Lists.newArrayList();
        for (AOIdentifiable item : list) {
            retVal.add(item);
        }
        return retVal;
    }

    private static final int convertIdentifier(String identifier) throws PersistenceException {
        try {
            return Integer.parseInt(identifier);
        }
        catch (NumberFormatException ex) {
            throw new PersistenceException(String.format("Identifier '%s' is not a valid ActiveObject identifier.", identifier), ex);
        }
    }

    private <EntityType extends IIdentifiable, AOEntityType extends AOIdentifiable> void cascadeDeleteOneToManyRelations(Class<EntityType> entityType, Class<AOEntityType> clazz, AOEntityType entity) throws PersistenceException {
        for (Method method : clazz.getMethods()) {
            CustomCascade cascade = method.getAnnotation(CustomCascade.class);
            try {
                if (cascade == null) continue;
                method.invoke(entity, new Object[0]);
            }
            catch (Exception ex) {
                throw new PersistenceException("Failed to custom cascade.", ex);
            }
        }
        TreeMap methodsToCascade = Maps.newTreeMap();
        for (Method method : clazz.getMethods()) {
            Cascade cascade;
            if (method == null || entity == null || (cascade = method.getAnnotation(Cascade.class)) == null) continue;
            int importance = cascade.importance();
            if (!methodsToCascade.containsKey(importance)) {
                methodsToCascade.put(importance, Lists.newArrayList((Object[])new Method[]{method}));
                continue;
            }
            ((List)methodsToCascade.get(importance)).add(method);
        }
        for (Integer importance : methodsToCascade.keySet()) {
            for (Method method : (List)methodsToCascade.get(importance)) {
                OneToMany oneToManyAnnotation = method.getAnnotation(OneToMany.class);
                OneToOne oneToOneAnnotation = method.getAnnotation(OneToOne.class);
                try {
                    Class<?> childEntityType;
                    Cascade cascade;
                    if (method == null || entity == null || (cascade = method.getAnnotation(Cascade.class)) == null) continue;
                    if (oneToManyAnnotation != null) {
                        AOIdentifiable[] children = (AOIdentifiable[])method.invoke(entity, new Object[0]);
                        childEntityType = method.getReturnType().getComponentType();
                        block16: for (AOIdentifiable identifiable : children) {
                            switch (cascade.mode()) {
                                case DELETE: {
                                    for (IEntityPersistence persistence : this.persistenceIndex.getPersistenceBeans()) {
                                        if (persistence.getDbInterfaceClass() != childEntityType) continue;
                                        persistence.delete(String.valueOf(identifiable.getIntegerId()), true);
                                        continue block16;
                                    }
                                    continue block16;
                                }
                                case NULLIFY: {
                                    String reverseSetter = cascade.reverseSetter();
                                    childEntityType.getMethod(reverseSetter, clazz).invoke((Object)identifiable, clazz.cast(null));
                                    identifiable.save();
                                }
                            }
                        }
                        continue;
                    }
                    if (oneToOneAnnotation == null) continue;
                    AOIdentifiable relation = (AOIdentifiable)method.invoke(entity, new Object[0]);
                    childEntityType = method.getReturnType();
                    if (relation == null) continue;
                    switch (cascade.mode()) {
                        case DELETE: {
                            this.delete(entityType, childEntityType, relation.getId());
                            break;
                        }
                        case NULLIFY: {
                            String reverseSetter = cascade.reverseSetter();
                            childEntityType.getMethod(reverseSetter, clazz).invoke((Object)relation, clazz.cast(null));
                            relation.save();
                        }
                    }
                }
                catch (Exception ex) {
                    throw new PersistenceException("Failed to cascade delete relation '" + method + "'", ex);
                }
            }
        }
    }

    @Override
    public ActiveObjectsAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    public void resetDatabase() throws Exception {
        long start = System.currentTimeMillis();
        DBResetSQL sql = new DBResetSQL(this);
        sql.reset();
        LOGGER.info("Database reset (" + (System.currentTimeMillis() - start) + "ms).", new Object[0]);
    }

    @Override
    public Connection getOrCreateConnection() throws SQLException {
        return this.getAccessor().getEntityManager().getProvider().getConnection();
    }
}

