/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.rand.backlog;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.generator.GeneratorUtils;
import com.radiantminds.roadmap.common.data.generator.backlog.BacklogConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.EpicConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.EstimationConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IBacklogConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IEpicConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IEstimateConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.IStoryConfiguration;
import com.radiantminds.roadmap.common.data.generator.backlog.StoryConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.IBacklogConfigurationCreator;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.IRandomizedBacklogConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.IRandomizedStoryConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.IRandomizedStructuredEpicConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.IRandomizedUnstructuredEpicConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.IAbilityConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.IResourceConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.ITeamConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.ITeamsConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class BacklogConfigurationCreator
implements IBacklogConfigurationCreator {
    private static final String EPIC_PREFIX = "epic-";
    private static final String STORY_PREFIX = "story-";
    private static final int STAGE_LIMIT = 5;

    @Override
    public IBacklogConfiguration createConfiguration(IRandomizedBacklogConfiguration backlogConfiguration, ITeamsConfiguration teamsConfiguration, Random random) {
        List<IEpicConfiguration> epicConfigurations = this.createEpicConfigurations(backlogConfiguration, teamsConfiguration, random);
        BacklogConfiguration configuration = new BacklogConfiguration(epicConfigurations);
        return configuration;
    }

    private List<IEpicConfiguration> createEpicConfigurations(IRandomizedBacklogConfiguration backlogConfiguration, ITeamsConfiguration teamsConfiguration, Random random) {
        ArrayList epicConfigurations = Lists.newArrayList();
        IRandomizedStructuredEpicConfiguration structuredEpicConfiguration = backlogConfiguration.getStructuredEpicConfiguration();
        IRandomizedUnstructuredEpicConfiguration unstructuredEpicConfiguration = backlogConfiguration.getUnstructuredEpicConfiguration();
        int epicCount = backlogConfiguration.getEpicCount();
        double structuredEpicPercentage = backlogConfiguration.getStructuredEpicPercentage();
        int structuredEpicCount = (int)((double)epicCount * structuredEpicPercentage);
        for (int epicIndex = 0; epicIndex < epicCount; ++epicIndex) {
            if (epicIndex < structuredEpicCount) {
                IEpicConfiguration sturcturedEpicConfiguration = this.createStructuredEpicConfiguration(epicIndex, structuredEpicConfiguration, teamsConfiguration, random);
                epicConfigurations.add(sturcturedEpicConfiguration);
                continue;
            }
            IEpicConfiguration epicConfiguration = this.createUnstructuredEpicConfiguration(epicIndex, unstructuredEpicConfiguration, teamsConfiguration, random);
            epicConfigurations.add(epicConfiguration);
        }
        return epicConfigurations;
    }

    private IEpicConfiguration createUnstructuredEpicConfiguration(int epicIndex, IRandomizedUnstructuredEpicConfiguration unstructuredEpicConfiguration, ITeamsConfiguration teamsConfiguration, Random random) {
        String title = EPIC_PREFIX + epicIndex;
        Set<IEstimateConfiguration> estimateConfiguration = this.createEpicEstimations(unstructuredEpicConfiguration, teamsConfiguration, random);
        EpicConfiguration epicConfiguration = new EpicConfiguration.Builder(title).withEstimateConfiguration(estimateConfiguration).build();
        return epicConfiguration;
    }

    private Set<IEstimateConfiguration> createEpicEstimations(IRandomizedUnstructuredEpicConfiguration epicConfiguration, ITeamsConfiguration teamsConfiguration, Random random) {
        int overallEstimation = GeneratorUtils.getRandomFromInterval(epicConfiguration.getMinOverallEstimation(), epicConfiguration.getMaxOverallEstimation(), random);
        Set<String> allSkills = this.getAllSkillTitles(teamsConfiguration);
        Map<String, Integer> workDemands = this.createWorkDemands(allSkills, overallEstimation, random);
        Set<IEstimateConfiguration> estimations = this.createEstimations(workDemands);
        return estimations;
    }

    private Set<String> getAllSkillTitles(ITeamsConfiguration teamsConfiguration) {
        HashSet skillTitles = Sets.newHashSet();
        List<ITeamConfiguration> teams = teamsConfiguration.getTeamConfigurations();
        for (ITeamConfiguration team : teams) {
            List<IResourceConfiguration> resources = team.getResourceConfigurations();
            Set<String> teamSkills = this.getAvailableSkills(resources);
            skillTitles.addAll(teamSkills);
        }
        return skillTitles;
    }

    private IEpicConfiguration createStructuredEpicConfiguration(int epicIndex, IRandomizedStructuredEpicConfiguration structuredEpicConfiguration, ITeamsConfiguration teamsConfiguration, Random random) {
        String title = EPIC_PREFIX + epicIndex;
        List<IStoryConfiguration> storyConfigurations = this.createStoryConfigurations(structuredEpicConfiguration, teamsConfiguration, random);
        EpicConfiguration epicConfiguration = new EpicConfiguration.Builder(title).withStoryConfigurations(storyConfigurations).build();
        return epicConfiguration;
    }

    private List<IStoryConfiguration> createStoryConfigurations(IRandomizedStructuredEpicConfiguration structuredEpicConfiguration, ITeamsConfiguration teamsConfiguration, Random random) {
        int storyCount = GeneratorUtils.getRandomFromInterval(structuredEpicConfiguration.getMinStories(), structuredEpicConfiguration.getMaxStories(), random);
        ArrayList storyConfigurations = Lists.newArrayList();
        IRandomizedStoryConfiguration randomizedStoryConfiguration = structuredEpicConfiguration.getStoryConfiguration();
        for (int storyIndex = 0; storyIndex < storyCount; ++storyIndex) {
            String title = STORY_PREFIX + storyIndex;
            Set<IEstimateConfiguration> estimationConfigurations = this.createEstimations(randomizedStoryConfiguration, teamsConfiguration, random);
            StoryConfiguration storyConfiguration = new StoryConfiguration.Builder(title).withEstimationConfigurations(estimationConfigurations).build();
            storyConfigurations.add(storyConfiguration);
        }
        return storyConfigurations;
    }

    private Set<IEstimateConfiguration> createEstimations(IRandomizedStoryConfiguration storyConfiguration, ITeamsConfiguration teamsConfiguration, Random random) {
        int overallEstimation = GeneratorUtils.getRandomFromInterval(storyConfiguration.getMinOverallEstimation(), storyConfiguration.getMaxOverallEstimation(), random);
        Set<String> selectedSkillTitles = this.getSkillSelection(teamsConfiguration, random);
        Map<String, Integer> workDemandMap = this.createWorkDemands(selectedSkillTitles, overallEstimation, random);
        Set<IEstimateConfiguration> estimations = this.createEstimations(workDemandMap);
        return estimations;
    }

    private Set<IEstimateConfiguration> createEstimations(Map<String, Integer> workDemandMap) {
        HashSet estimations = Sets.newHashSet();
        for (Map.Entry<String, Integer> workEntry : workDemandMap.entrySet()) {
            String skillTitle = workEntry.getKey();
            double value = workEntry.getValue().intValue();
            EstimationConfiguration estimationConfiguration = new EstimationConfiguration.Builder(value).targetType("skill").title(skillTitle).build();
            estimations.add(estimationConfiguration);
        }
        return estimations;
    }

    private Map<String, Integer> createWorkDemands(Set<String> selectedSkillTitles, int overallEstimation, Random random) {
        HashMap workDemand = Maps.newHashMap();
        ArrayList skillList = Lists.newArrayList(selectedSkillTitles);
        for (int i = 0; i < overallEstimation; ++i) {
            String skill = (String)skillList.get(random.nextInt(skillList.size()));
            if (workDemand.containsKey(skill)) {
                workDemand.put(skill, (Integer)workDemand.get(skill) + 1);
                continue;
            }
            workDemand.put(skill, 1);
        }
        return workDemand;
    }

    private Set<String> getSkillSelection(ITeamsConfiguration teamsConfiguration, Random random) {
        List<ITeamConfiguration> teamConfigurations = teamsConfiguration.getTeamConfigurations();
        List<IResourceConfiguration> resourceSelection = this.getRandomFromCommonTeam(teamConfigurations, 5, random);
        Set<String> availableSkills = this.getAvailableSkills(resourceSelection);
        return availableSkills;
    }

    private List<IResourceConfiguration> getRandomFromCommonTeam(List<ITeamConfiguration> teamConfigurations, int stageLimit, Random random) {
        ITeamConfiguration selectedTeam = GeneratorUtils.selectRandomElement(teamConfigurations, random);
        List<IResourceConfiguration> resources = selectedTeam.getResourceConfigurations();
        List<IResourceConfiguration> selectedResources = GeneratorUtils.selectRandomSubset(resources, stageLimit, random);
        return selectedResources;
    }

    private Set<String> getAvailableSkills(Collection<IResourceConfiguration> resourceSelection) {
        HashSet availableSkills = Sets.newHashSet();
        for (IResourceConfiguration resourceConfiguration : resourceSelection) {
            Set<IAbilityConfiguration> abilities = resourceConfiguration.getAbilityConfigurations();
            for (IAbilityConfiguration ability : abilities) {
                String title = ability.getTitle();
                availableSkills.add(title);
            }
        }
        return availableSkills;
    }
}

