/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.rand.backlog;

import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.IRandomizedStoryConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.IRandomizedStructuredEpicConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.RandomizedStoryConfiguration;

public class RandomizedStructuredEpicConfiguration
implements IRandomizedStructuredEpicConfiguration {
    private final int minStories;
    private final int maxStories;
    private final IRandomizedStoryConfiguration storyConfiguration;

    protected RandomizedStructuredEpicConfiguration(int minStories, int maxStories, IRandomizedStoryConfiguration storyConfiguration) {
        this.minStories = minStories;
        this.maxStories = maxStories;
        this.storyConfiguration = storyConfiguration;
    }

    @Override
    public int getMinStories() {
        return this.minStories;
    }

    @Override
    public int getMaxStories() {
        return this.maxStories;
    }

    @Override
    public IRandomizedStoryConfiguration getStoryConfiguration() {
        return this.storyConfiguration;
    }

    public static class Builder {
        private int minStories = 3;
        private int maxStories = 15;
        private IRandomizedStoryConfiguration storyConfiguration = new RandomizedStoryConfiguration.Builder().build();

        public Builder withStoryCountBetween(int minStories, int maxStorie) {
            Preconditions.checkArgument((minStories <= maxStorie ? 1 : 0) != 0);
            this.minStories = minStories;
            this.maxStories = maxStorie;
            return this;
        }

        public Builder withStoryConfiguration(IRandomizedStoryConfiguration storyConfiguration) {
            this.storyConfiguration = storyConfiguration;
            return this;
        }

        public RandomizedStructuredEpicConfiguration build() {
            return new RandomizedStructuredEpicConfiguration(this.minStories, this.maxStories, this.storyConfiguration);
        }
    }
}

