/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.common;

import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import java.sql.Connection;
import org.apache.commons.dbutils.DbUtils;

public class DBResetSQL
extends BaseAOPersistenceSQL {
    private static final Log LOGGER = Log.with(DBResetSQL.class);
    private final ActiveObjectsUtilities activeObjectsUtilities;
    private static String mySqlCachedQuery = null;

    public DBResetSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
        this.activeObjectsUtilities = activeObjectsUtilities;
    }

    public void reset() throws Exception {
        block4: {
            Connection conn = this.activeObjectsUtilities.getOrCreateConnection();
            try {
                String dbType = conn.getMetaData().getDatabaseProductName().toLowerCase();
                LOGGER.info("Resetting Database: " + dbType, new Object[0]);
                if (dbType.contains("postgresql")) {
                    this.resetPostgreSQL();
                    break block4;
                }
                throw new RuntimeException("Unknow database type '" + dbType + "'. Unable to reset.");
            }
            finally {
                DbUtils.closeQuietly(conn);
            }
        }
    }

    private void resetPostgreSQL() throws Exception {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.raw("DO\n$func$\nBEGIN\n   EXECUTE (\n      SELECT 'TRUNCATE TABLE '\n             || string_agg(quote_ident(t.tablename), ', ')\n             || ' RESTART IDENTITY CASCADE'\n      FROM   pg_tables t\n      WHERE  t.schemaname = 'public'\n   );\nEND\n$func$;");
            }
        });
    }
}

