/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimationAppender;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimationDataBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.ReplanningRelationsDataBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.ResultSetParsingUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.ResultSetReader;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.SubqueryDataEnrichment;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemDataBlock;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemQueryRowData;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.filter.EstimateFilter;
import com.radiantminds.roadmap.common.filter.IWorkItemFilter;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import com.radiantminds.roadmap.common.stats.MonitoredCallResult;
import com.radiantminds.roadmap.common.stats.MonitoredCallResultWrapper;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WorkItemSelectQueryParser {
    private final ResultSetReader resultSetReader;
    private final EstimationAppender estimationAppender;
    private final SubqueryDataEnrichment subqueryDataEnrichment;

    WorkItemSelectQueryParser(ActiveObjectsUtilities activeObjectsUtilities, PortfolioResourcePersistence resourcePersistence, WorkItemExtension workItemExtension) {
        this(new ResultSetReader(), new EstimationAppender(), new SubqueryDataEnrichment(activeObjectsUtilities, resourcePersistence, workItemExtension));
    }

    public WorkItemSelectQueryParser(ResultSetReader resultSetReader, EstimationAppender estimationAppender, SubqueryDataEnrichment subqueryDataEnrichment) {
        this.resultSetReader = resultSetReader;
        this.estimationAppender = estimationAppender;
        this.subqueryDataEnrichment = subqueryDataEnrichment;
    }

    public MonitoredCallResult<? extends List<? extends IWorkItem>> parse(String planId, ResultSet resultSet, IWorkItemFilter filter, boolean includeReplanning, boolean includeDoneDependencies, boolean enrichWithExtensions, ProgressConfiguration progressConfiguration) throws Exception {
        if (filter != null) {
            filter.setItemsCutoffDueToLimit(false);
        }
        EstimateFilter estimateFilter = new EstimateFilter(filter);
        int workItemLevels = ResultSetParsingUtils.calculateLevels(resultSet, includeReplanning);
        int itemCounter = 1;
        HashMap workItemDataBlocks = Maps.newHashMap();
        HashMap itemMap = Maps.newHashMap();
        String lastLowestLevelId = null;
        ArrayList potentialBlocks = Lists.newArrayList();
        ArrayList retVal = Lists.newArrayList();
        HashSet retValKeys = Sets.newHashSet();
        RestWorkItem noInitiative = new RestWorkItem("-1", null, null);
        noInitiative.setChildren(Lists.newArrayList());
        noInitiative.setType(WorkItems.Types.INITIATIVE);
        while (resultSet.next()) {
            WorkItemQueryRowData data = this.resultSetReader.parserNextLine(resultSet, workItemLevels, includeReplanning, workItemDataBlocks);
            List<RestWorkItem> itemsInBlock = this.getItemsOfRow(itemMap, data);
            String currentLowestLevelId = itemsInBlock.get(0).getId();
            if (!currentLowestLevelId.equals(lastLowestLevelId)) {
                itemCounter += WorkItemSelectQueryParser.considerPotentialBlocksForAdd(potentialBlocks, retVal, retValKeys, itemMap, noInitiative, itemCounter, filter, estimateFilter);
                if (filter != null && filter.itemsCutoffDueToLimit().booleanValue()) break;
                potentialBlocks.clear();
            }
            if (data.getEstimationData().isPresent()) {
                this.estimationAppender.handleEstimates(itemsInBlock.get(0), (EstimationDataBlock)data.getEstimationData().get());
            }
            if (data.getReplanningRelationData().isPresent()) {
                ReplanningRelationsDataBlock replanningRelationData = (ReplanningRelationsDataBlock)data.getReplanningRelationData().get();
                itemsInBlock.get(0).setReplanningTeamId((String)replanningRelationData.getTeamId().orNull());
                itemsInBlock.get(0).setReplanningTeamSet(replanningRelationData.isTeamSet());
                itemsInBlock.get(0).setReplanningReleaseId((String)replanningRelationData.getReleaseId().orNull());
                itemsInBlock.get(0).setReplanningStreamId((String)replanningRelationData.getStreamId().orNull());
            }
            potentialBlocks.add(itemsInBlock);
            lastLowestLevelId = currentLowestLevelId;
        }
        if (filter == null || !filter.itemsCutoffDueToLimit().booleanValue()) {
            WorkItemSelectQueryParser.considerPotentialBlocksForAdd(potentialBlocks, retVal, retValKeys, itemMap, noInitiative, itemCounter, filter, estimateFilter);
        }
        retVal.add(noInitiative);
        itemMap.put(noInitiative.getId(), noInitiative);
        MonitoredCallResult<Void> callResult = this.subqueryDataEnrichment.enrichItems(planId, includeDoneDependencies, includeReplanning, enrichWithExtensions, progressConfiguration, itemMap);
        return MonitoredCallResultWrapper.wrap(retVal, callResult.getMonitoredMetrics());
    }

    private List<RestWorkItem> getItemsOfRow(Map<String, RestWorkItem> itemMap, WorkItemQueryRowData data) {
        ArrayList itemsInBlock = Lists.newArrayList();
        for (int i = data.getWorkItemData().size() - 1; i >= 0; --i) {
            RestWorkItem item;
            WorkItemDataBlock block = data.getWorkItemData().get(i);
            if (itemMap.containsKey(block.getId())) {
                item = itemMap.get(block.getId());
                itemsInBlock.add(item);
                continue;
            }
            item = WorkItemSelectQueryParser.createWorkItem(block);
            item.setChildren(Lists.newArrayList());
            itemsInBlock.add(item);
            itemMap.put(item.getId(), item);
        }
        return itemsInBlock;
    }

    private static int considerPotentialBlocksForAdd(List<List<RestWorkItem>> potentialBlocks, List<RestWorkItem> retVal, Set<String> retValKeys, Map<String, RestWorkItem> itemMap, RestWorkItem noInitiative, int itemCounter, IWorkItemFilter filter, EstimateFilter estimateFilter) {
        if (filter != null && filter.getLimit() != null && itemCounter >= filter.getLimit()) {
            filter.setItemsCutoffDueToLimit(true);
            return 0;
        }
        int itemsAdded = 0;
        ArrayList allowedBlocks = Lists.newArrayList();
        for (List<RestWorkItem> block : potentialBlocks) {
            if (!estimateFilter.allowedByFilter(block.get(0))) continue;
            allowedBlocks.add(block);
        }
        for (List<RestWorkItem> block : allowedBlocks) {
            for (int i = block.size() - 1; i >= 0; --i) {
                boolean hasChildInBlock = i > 0;
                RestWorkItem toConsider = block.get(i);
                if (retValKeys.contains(toConsider.getId())) continue;
                String parentId = null;
                if (i < block.size() - 1) {
                    parentId = block.get(i + 1).getId();
                }
                if (parentId != null) {
                    itemMap.get(parentId).addChild(toConsider);
                    toConsider.setParent(itemMap.get(parentId));
                } else if (WorkItems.Types.EPIC.equals(toConsider.getType())) {
                    noInitiative.addChild(toConsider);
                    toConsider.setParent(noInitiative);
                } else {
                    retVal.add(toConsider);
                }
                retValKeys.add(toConsider.getId());
                if (filter == null || filter.getLimit() == null || itemCounter + ++itemsAdded < filter.getLimit()) continue;
                if (hasChildInBlock) {
                    WorkItemSelectQueryParser.cleanUpStructureds(toConsider, retVal);
                }
                filter.setItemsCutoffDueToLimit(true);
                return itemsAdded;
            }
        }
        return itemsAdded;
    }

    private static void cleanUpStructureds(RestWorkItem toConsider, List<RestWorkItem> retVal) {
        if (toConsider.getParent() == null) {
            retVal.remove(toConsider);
        } else {
            RestWorkItem parent = (RestWorkItem)toConsider.getParent();
            parent.getRestChildren().remove(toConsider);
            if (parent.getChildCount() == 0) {
                WorkItemSelectQueryParser.cleanUpStructureds(parent, retVal);
            }
        }
    }

    private static RestWorkItem createWorkItem(WorkItemDataBlock dataBlock) {
        String id = dataBlock.getId();
        String title = (String)dataBlock.getTitle().orNull();
        String description = (String)dataBlock.getDescription().orNull();
        RestWorkItem item = new RestWorkItem(id, title, description);
        item.setDetails((String)dataBlock.getDetails().orNull());
        item.setEarliestStart((Long)dataBlock.getEarliestStart().orNull());
        item.setReleaseId((String)dataBlock.getReleaseId().orNull());
        item.setSortOrder((Long)dataBlock.getSortOrder().orNull());
        item.setStatus(dataBlock.getStatus());
        item.setStreamId(dataBlock.getStreamId());
        item.setThemeId(dataBlock.getThemeId());
        item.setTargetEnd((Long)dataBlock.getTargetEnd().orNull());
        item.setTargetStart((Long)dataBlock.getTargetStart().orNull());
        item.setTeamId((String)dataBlock.getTeamId().orNull());
        item.setSprintId((String)dataBlock.getSprintId().orNull());
        item.setType(dataBlock.getType());
        item.setVersion(dataBlock.getVersion());
        item.setHasOriginalEstimates(dataBlock.isOriginalEstimatesSet());
        item.setReplanningStatus((Integer)dataBlock.getReplanningStatus().orNull());
        item.setBusinessValue((Double)dataBlock.getBusinessValue().orNull());
        return item;
    }
}

