/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.port;

import com.radiantminds.roadmap.common.data.persistence.ao.port.IAnonymisationProvider;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IKeyResolver;

public class MethodXmlConfiguration {
    private final String name;
    private final String databaseColumnName;
    private final String methodName;
    private final IKeyResolver resolver;
    private final String dependsOn;
    private final boolean isPrimaryKey;
    private final boolean isForeignKey;
    private final boolean isPolyType;
    private final Class<?> returnType;
    private final IAnonymisationProvider anonymisationProvider;

    public MethodXmlConfiguration(String name, String databaseColumnName, String methodName, IKeyResolver resolver, String dependsOn, boolean isPrimaryKey, boolean isForeignKey, boolean isPolyType, Class<?> returnType, IAnonymisationProvider anonymisationProvider) {
        this.name = name;
        this.databaseColumnName = databaseColumnName;
        this.methodName = methodName;
        this.resolver = resolver;
        this.dependsOn = dependsOn;
        this.isPrimaryKey = isPrimaryKey;
        this.isForeignKey = isForeignKey;
        this.isPolyType = isPolyType;
        this.returnType = returnType;
        this.anonymisationProvider = anonymisationProvider;
    }

    public boolean isPolyType() {
        return this.isPolyType;
    }

    public String getDatabaseColumnName() {
        if (this.isForeignKey && this.databaseColumnName.endsWith("id")) {
            return this.databaseColumnName.substring(0, this.databaseColumnName.length() - 2);
        }
        if (this.isPolyType && this.databaseColumnName.endsWith("type")) {
            return this.databaseColumnName.substring(0, this.databaseColumnName.length() - 4);
        }
        return this.databaseColumnName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?> getReturnType() {
        if (this.isForeignKey) {
            if (this.resolver.getPrefix(null) == null) {
                return Integer.class;
            }
            return String.class;
        }
        return this.returnType;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    public String getName() {
        return this.name;
    }

    public IKeyResolver getResolver() {
        return this.resolver;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public IAnonymisationProvider getAnonymisationProvider() {
        return this.anonymisationProvider;
    }
}

