/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.sql;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGeneratorFactory;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;

public abstract class AOQueryGenerator {
    private static final Log LOGGER = Log.with(AOQueryGenerator.class);
    private final EntityManager manager;
    private final Map<String, Class<?>> tableAliases;
    private final Connection connection;
    private final ActiveObjectsUtilities activeObjectsUtilities;
    protected StringBuilder query;
    protected boolean lastCol = false;
    private final String quoteString;
    private final boolean upperCaseIdentifiers;
    private final String schema;
    private int paramCounter = 1;
    private final Map<Integer, String> paramsString = Maps.newHashMap();
    private final Map<Integer, Integer> paramsInteger = Maps.newHashMap();
    private final Map<Integer, Long> paramsLong = Maps.newHashMap();
    private final Map<Integer, Double> paramsDouble = Maps.newHashMap();
    IParameterAddCallback INTEGER_CALLBACK = new IParameterAddCallback(){

        @Override
        public void addToParameterMap(int counter, String value) {
            AOQueryGenerator.this.paramsInteger.put(counter, Integer.parseInt(value));
        }
    };
    IParameterAddCallback STRING_CALLBACK = new IParameterAddCallback(){

        @Override
        public void addToParameterMap(int counter, String value) {
            AOQueryGenerator.this.paramsString.put(counter, value);
        }
    };

    protected AOQueryGenerator(Connection connection, ActiveObjectsUtilities activeObjectsUtilities) throws SQLException {
        this.connection = connection;
        this.activeObjectsUtilities = activeObjectsUtilities;
        this.manager = activeObjectsUtilities.getAccessor().getEntityManager();
        DatabaseMetaData meta = connection.getMetaData();
        this.quoteString = meta.getIdentifierQuoteString();
        this.upperCaseIdentifiers = meta.storesUpperCaseIdentifiers();
        this.query = new StringBuilder();
        this.tableAliases = Maps.newHashMap();
        String schema = this.manager.getProvider().getSchema();
        this.schema = schema != null && !"".equals(schema.trim()) ? schema : null;
    }

    public void setLastCol(boolean lastOperationWasColumn) {
        this.lastCol = lastOperationWasColumn;
    }

    public String getSql() {
        return this.query.toString();
    }

    public String getParameterAsReadableString() {
        if (this.paramsString.size() == 0 && this.paramsInteger.size() == 0 && this.paramsDouble.size() == 0 && this.paramsLong.size() == 0) {
            return null;
        }
        StringBuilder retVal = new StringBuilder();
        retVal.append("Parameters: \r\n");
        for (int i = 1; i <= this.paramCounter; ++i) {
            if (this.paramsString.containsKey(i)) {
                String paramString = this.paramsString.get(i);
                if (paramString.length() > 40) {
                    paramString = paramString.substring(0, 37) + "...";
                }
                retVal.append("[STRING ]\t" + i + "\t" + paramString + "\r\n");
            }
            if (this.paramsInteger.containsKey(i)) {
                retVal.append("[INTEGER]\t" + i + "\t" + this.paramsInteger.get(i) + "\r\n");
            }
            if (this.paramsLong.containsKey(i)) {
                retVal.append("[LONG   ]\t" + i + "\t" + this.paramsLong.get(i) + "\r\n");
            }
            if (!this.paramsDouble.containsKey(i)) continue;
            retVal.append("[DOUBLE ]\t" + i + "\t" + this.paramsDouble.get(i) + "\r\n");
        }
        return retVal.toString();
    }

    public PreparedStatement generateStatement(Connection connection, String ... idParams) throws SQLException {
        PreparedStatement statement = idParams.length > 0 ? connection.prepareStatement(this.query.toString(), idParams) : connection.prepareStatement(this.query.toString());
        for (Integer position : this.paramsString.keySet()) {
            statement.setString(position, this.paramsString.get(position));
        }
        for (Integer position : this.paramsInteger.keySet()) {
            statement.setInt(position, this.paramsInteger.get(position));
        }
        for (Integer position : this.paramsLong.keySet()) {
            statement.setLong(position, this.paramsLong.get(position));
        }
        for (Integer position : this.paramsDouble.keySet()) {
            statement.setDouble(position, this.paramsDouble.get(position));
        }
        return statement;
    }

    public AOQueryGenerator withTable(Class<?> table, String alias) {
        this.tableAliases.put(alias, table);
        return this;
    }

    public AOQueryGenerator from(String ... alii) {
        this.query.append("FROM ");
        for (int i = 0; i < alii.length; ++i) {
            this.table(alii[i]);
            if (i >= alii.length - 1) continue;
            this.query.append(",");
        }
        this.lastCol = false;
        return this;
    }

    public AOQueryGenerator where() {
        this.appendBaseString("WHERE");
        return this;
    }

    public AOQueryGenerator select() {
        this.appendBaseString("SELECT");
        return this;
    }

    public AOQueryGenerator distinct() {
        this.appendBaseString("DISTINCT");
        return this;
    }

    public AOQueryGenerator update() {
        this.appendBaseString("UPDATE");
        return this;
    }

    public AOQueryGenerator deleteFrom() {
        this.appendBaseString("DELETE FROM");
        return this;
    }

    public AOQueryGenerator insert() {
        this.appendBaseString("INSERT INTO");
        return this;
    }

    public AOQueryGenerator set() {
        this.appendBaseString("SET");
        return this;
    }

    public AOQueryGenerator orderBy() {
        this.appendBaseString("ORDER BY");
        return this;
    }

    public AOQueryGenerator groupBy() {
        this.appendBaseString("GROUP BY");
        return this;
    }

    public AOQueryGenerator desc() {
        return this.raw("DESC");
    }

    public AOQueryGenerator table(String tableAlias) {
        return this.table(tableAlias, true);
    }

    public AOQueryGenerator tableNoAlias(String tableAlias) {
        return this.table(tableAlias, false);
    }

    private AOQueryGenerator table(String tableAlias, boolean useAlias) {
        this.appendParameter(this.tableAliases.get(tableAlias));
        if (useAlias) {
            this.appendTableAlias(tableAlias);
            this.query.append(" ");
        }
        this.lastCol = false;
        return this;
    }

    public AOQueryGenerator colNoAlias(String tableAlias, String fk) {
        return this.col(tableAlias, fk, true, false);
    }

    private AOQueryGenerator colNoAlias(String tableAlias, String fk, boolean dynamicKey) {
        return this.col(tableAlias, fk, dynamicKey, false);
    }

    public AOQueryGenerator colId(String tableAlias) {
        return this.col(tableAlias, "ID_OTHER", false);
    }

    public AOQueryGenerator colIdNoAlias(String tableAlias) {
        return this.colNoAlias(tableAlias, "ID_OTHER", false);
    }

    public AOQueryGenerator colPolyType(String tableAlias, String fk) {
        return this.colPolyType(tableAlias, fk, true);
    }

    public AOQueryGenerator colPolyTypeNoAlias(String tableAlias, String fk) {
        return this.colPolyType(tableAlias, fk, false);
    }

    private AOQueryGenerator colPolyType(String tableAlias, String fk, boolean alias) {
        Class<?> table;
        Method method;
        if (this.lastCol) {
            this.query.append(", ");
        }
        if ((method = AOQueryGenerator.getMethod(table = this.tableAliases.get(tableAlias), fk)) == null) {
            throw new RuntimeException(String.format("Failed to build query. Method '%s' not found on table '%s' ", fk, table.getSimpleName()));
        }
        String polyTypeName = this.manager.getFieldNameConverter().getPolyTypeName(method);
        if (alias) {
            this.appendTableAlias(tableAlias);
            this.query.append(".");
        }
        this.query.append(this.quote(polyTypeName));
        this.lastCol = true;
        return this;
    }

    public AOQueryGenerator col(String tableAlias, String fk) {
        return this.col(tableAlias, fk, true);
    }

    public AOQueryGenerator col(String tableAlias, String fk, boolean dynamicKey) {
        return this.col(tableAlias, fk, dynamicKey, true);
    }

    public AOQueryGenerator col(String tableAlias, String fk, boolean dynamicKey, boolean useAlias) {
        if (this.lastCol) {
            this.query.append(", ");
        }
        if (useAlias) {
            this.appendTableAlias(tableAlias);
            this.query.append(".");
        }
        this.appendColParamter(tableAlias, fk, dynamicKey);
        this.lastCol = true;
        return this;
    }

    public AOQueryGenerator appendTableAlias(String tableAlias) {
        this.query.append(tableAlias);
        return this;
    }

    public AOQueryGenerator colCoalesce(String tableAlias, String fk, String altValue) {
        if (this.lastCol) {
            this.query.append(", ");
        }
        this.query.append("coalesce(");
        this.appendTableAlias(tableAlias);
        this.query.append(".");
        this.appendColParamter(tableAlias, fk, true);
        this.query.append("," + altValue + ")");
        this.lastCol = true;
        return this;
    }

    public AOQueryGenerator colCoalesce(String tableAlias, String fk, boolean dynamicKey, String altTableAlias, String altFK, boolean altDynamicKey) {
        if (this.lastCol) {
            this.query.append(", ");
        }
        this.query.append("coalesce(");
        this.appendTableAlias(tableAlias);
        this.query.append(".");
        this.appendColParamter(tableAlias, fk, dynamicKey);
        this.query.append(",");
        this.query.append(altTableAlias);
        this.query.append(".");
        this.appendColParamter(altTableAlias, altFK, altDynamicKey);
        this.query.append(") ");
        this.lastCol = true;
        return this;
    }

    public AOQueryGenerator colBooleanOrAggregation(String tableAlias, String fk) {
        if (this.lastCol) {
            this.query.append(", ");
        }
        this.appendBooleanOrAggregation(tableAlias, fk);
        this.lastCol = true;
        return this;
    }

    protected void appendBooleanOrAggregation(String tableAlias, String fk) {
        this.query.append("MAX(");
        this.appendTableAlias(tableAlias);
        this.query.append(".");
        this.appendColParamter(tableAlias, fk, true);
        this.query.append(")");
    }

    private static Method getMethod(Class<?> table, String fk) {
        Method method = null;
        try {
            method = table.getMethod(fk, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            LOGGER.debug("method not found - search for similars", new Object[0]);
            int shortestMatchedMethod = Integer.MAX_VALUE;
            for (Method m : table.getMethods()) {
                int methodLength;
                if (!m.getName().startsWith("get") && !m.getName().startsWith("is") || !m.getName().toLowerCase().contains(fk.toLowerCase()) || (methodLength = m.getName().length()) >= shortestMatchedMethod) continue;
                method = m;
                shortestMatchedMethod = methodLength;
            }
        }
        return method;
    }

    public AOQueryGenerator appendColParamter(String tableAlias, String fk, boolean dynamicKey) {
        Class<?> table = this.tableAliases.get(tableAlias);
        if (dynamicKey) {
            Method method = AOQueryGenerator.getMethod(table, fk);
            if (method == null) {
                throw new RuntimeException(String.format("Failed to build query. Method '%s' not found on table '%s' ", fk, table.getSimpleName()));
            }
            this.appendParameter(method);
        } else {
            this.appendNonMethodField(fk);
        }
        return this;
    }

    protected void appendNonMethodField(String fk) {
        this.appendParameter(fk);
    }

    public AOQueryGenerator leftJoin() {
        this.appendBaseString("LEFT JOIN");
        return this;
    }

    public AOQueryGenerator union() {
        this.appendBaseString("UNION");
        return this;
    }

    public AOQueryGenerator on() {
        this.appendBaseString("ON");
        return this;
    }

    public AOQueryGenerator lowerCase() {
        return this.raw("LCASE");
    }

    public AOQueryGenerator nullValue() {
        return this.raw("NULL");
    }

    public AOQueryGenerator nullValueAsInt() {
        return this.nullValue();
    }

    public AOQueryGenerator colIdAsString(String tableAlias) {
        return this.colAsString(tableAlias, "ID_OTHER", false);
    }

    public AOQueryGenerator colAsString(String tableAlias, String col) {
        return this.colAsString(tableAlias, col, true);
    }

    public AOQueryGenerator colAsString(String tableAlias, String col, boolean dynamicKey) {
        this.raw("CAST(", false).col(tableAlias, col, dynamicKey).raw("AS").varchar().raw(") AS ", false).quoted(col);
        this.setLastCol(true);
        return this;
    }

    public AOQueryGenerator colAsInt(String tableAlias, String col) {
        return this.col(tableAlias, col);
    }

    public AOQueryGenerator colAsInt(String tableAlias, String col, boolean dynamic) {
        return this.col(tableAlias, col, dynamic);
    }

    protected void addParameterList(Collection<String> values, IParameterAddCallback callback) {
        boolean appendComma = false;
        for (String value : values) {
            if (appendComma) {
                this.query.append(", ");
            } else {
                appendComma = true;
            }
            this.query.append("?");
            callback.addToParameterMap(this.paramCounter, value);
            ++this.paramCounter;
        }
    }

    public AOQueryGenerator inNumeric(InOperandCallback operandCallback, Collection<String> values) throws SQLException {
        return this.inInternal(operandCallback, values, this.INTEGER_CALLBACK);
    }

    public AOQueryGenerator inIntegers(InOperandCallback operandCallback, Collection<Integer> values) throws SQLException {
        ArrayList stringVals = Lists.newArrayList();
        for (Integer val : values) {
            stringVals.add(String.valueOf(val));
        }
        return this.inInternal(operandCallback, stringVals, this.INTEGER_CALLBACK);
    }

    @Deprecated
    public AOQueryGenerator in(InOperandCallback operandCallback, Collection<String> values) throws SQLException {
        return this.inInternal(operandCallback, values, this.STRING_CALLBACK);
    }

    protected String getOperand(InOperandCallback operandCallback) throws SQLException {
        AOQueryGenerator generator = AOQueryGeneratorFactory.create(this.connection, this.activeObjectsUtilities);
        for (Map.Entry<String, Class<?>> entry : this.tableAliases.entrySet()) {
            generator.withTable(entry.getValue(), entry.getKey());
        }
        operandCallback.generateOperand(generator);
        return generator.getSql();
    }

    protected AOQueryGenerator inInternal(InOperandCallback operandCallback, Collection<String> values, IParameterAddCallback callback) throws SQLException {
        this.query.append(this.getOperand(operandCallback));
        this.query.append("IN (");
        this.addParameterList(values, callback);
        this.query.append(") ");
        this.lastCol = false;
        return this;
    }

    public AOQueryGenerator like(String value) {
        this.query.append("LIKE ? ");
        this.paramsString.put(this.paramCounter++, "%" + value + "%");
        this.lastCol = false;
        return this;
    }

    public AOQueryGenerator startsWith(String value) {
        this.query.append("LIKE ?");
        this.paramsString.put(this.paramCounter++, value + "%");
        this.lastCol = false;
        return this;
    }

    public AOQueryGenerator notLike(String value) {
        this.raw("NOT");
        return this.like(value);
    }

    public AOQueryGenerator and() {
        this.appendBaseString("AND");
        return this;
    }

    public AOQueryGenerator or() {
        this.appendBaseString("OR");
        return this;
    }

    public AOQueryGenerator eq() {
        this.appendBaseString("=");
        return this;
    }

    public AOQueryGenerator neq() {
        this.appendBaseString("!=");
        return this;
    }

    public AOQueryGenerator neqAlt() {
        this.appendBaseString("<>");
        return this;
    }

    public AOQueryGenerator gt() {
        this.appendBaseString(">");
        return this;
    }

    public AOQueryGenerator gte() {
        this.appendBaseString(">=");
        return this;
    }

    public AOQueryGenerator lt() {
        this.appendBaseString("<");
        return this;
    }

    public AOQueryGenerator isNull() {
        this.appendBaseString("IS NULL");
        return this;
    }

    public AOQueryGenerator isNotNull() {
        this.appendBaseString("IS NOT NULL");
        return this;
    }

    public AOQueryGenerator raw(Object s) {
        return this.raw(s, true);
    }

    public AOQueryGenerator raw(Object s, boolean addSpacing) {
        this.appendBaseString(String.valueOf(s), addSpacing);
        return this;
    }

    public AOQueryGenerator str(Object s) {
        if (s == null) {
            return this.raw("null");
        }
        this.paramsString.put(this.paramCounter++, String.valueOf(s));
        return this.raw("?");
    }

    public AOQueryGenerator quoted(Object s) {
        if (s == null) {
            return this.raw("null");
        }
        return this.raw(this.quote(String.valueOf(s)));
    }

    public AOQueryGenerator bool(Boolean b) {
        return this.raw(b);
    }

    public AOQueryGenerator numeric(Double d) {
        if (d == null) {
            return this.raw("null");
        }
        this.paramsDouble.put(this.paramCounter++, d);
        return this.raw("?");
    }

    public AOQueryGenerator numeric(Long l) {
        if (l == null) {
            return this.raw("null");
        }
        this.paramsLong.put(this.paramCounter++, l);
        return this.raw("?");
    }

    public AOQueryGenerator numeric(Integer i) {
        if (i == null) {
            return this.raw("null");
        }
        this.paramsInteger.put(this.paramCounter++, i);
        return this.raw("?");
    }

    public AOQueryGenerator numeric(String b) {
        if (b == null) {
            return this.raw("null");
        }
        try {
            return this.numeric(Integer.parseInt(b));
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Value supplied for numeric query item generation was not numeric: " + b, new Object[0]);
            throw ex;
        }
    }

    public void replace(String pattern, String replacement) {
        String replaced = Pattern.compile(pattern).matcher(this.query).replaceAll(replacement);
        this.query = new StringBuilder(replaced);
    }

    private void appendParameter(Object parameter) {
        if (parameter instanceof Class && RawEntity.class.isAssignableFrom((Class)parameter)) {
            if (this.schema != null) {
                this.query.append(this.quote(this.schema) + ".");
            }
            this.query.append(this.quote(this.manager.getTableNameConverter().getName((Class)parameter)));
        } else if (parameter instanceof Method) {
            this.query.append(this.quote(this.manager.getFieldNameConverter().getName((Method)parameter)));
        } else {
            this.query.append(this.quote(String.valueOf(parameter)));
        }
        this.query.append(" ");
    }

    protected String quote(String s) {
        if (this.upperCaseIdentifiers) {
            s = s.toUpperCase();
        }
        return String.format("%s%s%s", this.quoteString, s, this.quoteString);
    }

    private void appendBaseString(String s) {
        this.appendBaseString(s, true);
    }

    private void appendBaseString(String s, boolean addSpacing) {
        this.query.append(s);
        if (addSpacing) {
            this.query.append(" ");
        }
        this.lastCol = false;
    }

    public String getTableAlias(Class<?> dbInterfaceClass) {
        for (Map.Entry<String, Class<?>> entry : this.tableAliases.entrySet()) {
            if (entry.getValue() != dbInterfaceClass) continue;
            return entry.getKey();
        }
        return null;
    }

    protected AOQueryGenerator varchar() {
        return this.raw("VARCHAR", false);
    }

    public static interface InOperandCallback {
        public void generateOperand(AOQueryGenerator var1);
    }

    protected static interface IParameterAddCallback {
        public void addToParameterMap(int var1, String var2);
    }
}

