/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.handlers.BadDeveloperException;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.EntityParam;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.Parameter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;

public class ContextAwareAnnotations {
    private final AbstractResourceMethod abstractResourceMethod;
    private final Optional<Parameter> entityContextParameter;
    private final Optional<Parameter> bulkEntityContextParameter;

    public ContextAwareAnnotations(AbstractResourceMethod abstractResourceMethod) {
        this.abstractResourceMethod = abstractResourceMethod;
        this.entityContextParameter = this.getParameter(EntityContext.class, EntityParam.class);
        this.bulkEntityContextParameter = this.getParameter(BulkEntityContext.class, EntityParam.class);
    }

    public boolean requiresEntityContext() {
        return this.entityContextParameter.isPresent();
    }

    public boolean requiresBulkEntityContext() {
        return this.bulkEntityContextParameter.isPresent();
    }

    public EntityParam getEntityParam() {
        if (this.requiresEntityContext() && this.requiresBulkEntityContext()) {
            throw new BadDeveloperException("Bad developer. Cannot require both entity context and bulk entity context.");
        }
        if (this.requiresEntityContext()) {
            return (EntityParam)((Parameter)this.entityContextParameter.get()).getAnnotation(EntityParam.class);
        }
        if (this.requiresBulkEntityContext()) {
            return (EntityParam)((Parameter)this.bulkEntityContextParameter.get()).getAnnotation(EntityParam.class);
        }
        throw new BadDeveloperException("Bad developer. Don't call getEntityParam unless you requested one!");
    }

    private Optional<Parameter> getParameter(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList parameterList = Lists.newArrayList();
        for (Parameter parameter : this.abstractResourceMethod.getParameters()) {
            if (parameter.getParameterClass() != type || !parameter.isAnnotationPresent(annotation)) continue;
            parameterList.add(parameter);
        }
        if (parameterList.size() > 1) {
            throw new BadDeveloperException("Bad developer. Multiple parameters for type " + type.getSimpleName() + " and annotation " + annotation.getSimpleName());
        }
        if (parameterList.size() == 0) {
            return Optional.absent();
        }
        return Optional.of(parameterList.get(0));
    }
}

