/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.common;

import com.radiantminds.roadmap.common.rest.entities.common.Result;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessage;
import javax.ws.rs.core.Response;

public final class ResponseBuilder {
    public static Response ok(Long expectedPlanVersion, Long planVersionOnRequestStart, Long planVersionOnRequestEnd, Long schedulingVersion, boolean ignoreVersionConflicts, Object entity) {
        Result result = Result.from(planVersionOnRequestEnd, schedulingVersion, entity);
        result.setPlanVersionConflict(ResponseBuilder.getPlanVersionConflict(expectedPlanVersion, planVersionOnRequestStart, ignoreVersionConflicts));
        return Response.ok((Object)result).build();
    }

    public static Response okForArray(Long expectedPlanVersion, Long planVersionOnRequestStart, Long planVersionOnRequestEnd, Long schedulingVersion, boolean ignoreVersionConflicts, Object[] entities) {
        Result result = Result.from(planVersionOnRequestEnd, schedulingVersion, entities);
        result.setPlanVersionConflict(ResponseBuilder.getPlanVersionConflict(expectedPlanVersion, planVersionOnRequestStart, ignoreVersionConflicts));
        return Response.ok((Object)result).build();
    }

    public static Response serverError(Object entity) {
        Result result = Result.from(entity);
        return Response.serverError().entity((Object)result).build();
    }

    public static Response ok(Object entity) {
        Result result = Result.from(entity);
        return Response.ok((Object)result).build();
    }

    public static Response okForArray(Object[] entities) {
        Result result = Result.from(entities);
        return Response.ok((Object)result).build();
    }

    public static Response badRequest(RestMessage cause) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)cause).build();
    }

    public static Response badRequest() {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    public static Response conflict(RestMessage cause) {
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)cause).build();
    }

    public static Response notFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public static Response noContent() {
        return Response.noContent().build();
    }

    private static Boolean getPlanVersionConflict(Long expectedPlanVersion, Long planVersionOnRequestStart, boolean ignoreVersionConflicts) {
        if (ignoreVersionConflicts) {
            return null;
        }
        if (ResponseBuilder.isVersionConflict(expectedPlanVersion, planVersionOnRequestStart)) {
            return Boolean.TRUE;
        }
        return null;
    }

    private static boolean isVersionConflict(Long expectedVersion, Long actualVersion) {
        if (expectedVersion == null || actualVersion == null) {
            return false;
        }
        return !expectedVersion.equals(actualVersion);
    }
}

