/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.plans;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.data.entities.plans.INonWorkingDay;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.entities.themes.ITheme;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.rest.entities.common.BaseRestDescribable;
import com.radiantminds.roadmap.common.rest.entities.common.IReplanningAware;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="plan")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestPlan
extends BaseRestDescribable
implements IPlan,
IReplanningAware {
    @XmlElement
    private Long date;
    @XmlElement
    private Long replanningDate;
    @XmlElement
    private Boolean inReplanning;
    @XmlElement
    private Long replanningVersion;
    @XmlElement
    private Boolean inStreamMode;
    @XmlElement
    private String template;
    @XmlElement
    private String accessMode;
    private Long planVersion;
    private Long schedulingVersion;
    private List<ITheme> themes;
    private List<IStage> stages;
    private List<ITeam> teams;
    private List<IWorkItem> workItems;
    private List<IPerson> persons;
    private List<IWorkItem> epics;
    private List<IWorkItem> stories;
    private List<IStream> streams;
    private List<INonWorkingDay> nonWorkingDays;

    @Deprecated
    private RestPlan() {
    }

    public RestPlan(String id, String title, String description) {
        super(id, title, description);
    }

    public RestPlan(IPlan plan) {
        super(plan);
        this.date = (Long)plan.getDate().orNull();
        this.replanningDate = (Long)plan.getReplanningDate().orNull();
        this.inReplanning = plan.getInReplanning();
        this.replanningVersion = plan.getReplanningVersion();
        this.inStreamMode = plan.getInStreamMode();
        this.setThemes(plan.getThemes());
        this.setStages(plan.getStages());
        this.setTeams(plan.getTeams());
        this.setWorkItems(plan.getWorkItems());
        this.epics = plan.getEpics();
        this.stories = plan.getStories();
        this.persons = plan.getPersons();
        this.setStreams(plan.getStreams());
        this.planVersion = plan.getPlanVersion();
        this.schedulingVersion = plan.getSchedulingVersion();
        IPlanConfiguration config = plan.getPlanConfiguration();
        this.template = config.getTemplateType();
        this.nonWorkingDays = plan.getNonWorkingDays();
    }

    @Override
    public List<IStream> getStreams() {
        return this.streams;
    }

    private void setStreams(List<IStream> streams) {
        this.streams = streams;
    }

    @Override
    public Long getPlanVersion() {
        return this.planVersion;
    }

    @Override
    public Optional<? extends SchedulingPerson> getPerson(final String personId) {
        return Iterables.tryFind(this.persons, (Predicate)new Predicate<IPerson>(){

            public boolean apply(@Nullable IPerson person) {
                return person.getId().equals(personId);
            }
        });
    }

    @Override
    public void setPlanVersion(Long planVersion) {
        this.planVersion = planVersion;
    }

    @Override
    public Long getSchedulingVersion() {
        return this.schedulingVersion;
    }

    @Override
    public List<INonWorkingDay> getNonWorkingDays() {
        return this.nonWorkingDays;
    }

    @Override
    public void setSchedulingVersion(Long schedulingVersion) {
        this.schedulingVersion = schedulingVersion;
    }

    @Override
    public Optional<Long> getDate() {
        return Optional.fromNullable((Object)this.date);
    }

    @Override
    public void setDate(Long date) {
        this.date = date;
    }

    @Override
    public Optional<Long> getReplanningDate() {
        return Optional.fromNullable((Object)this.replanningDate);
    }

    @Override
    public void setReplanningDate(Long date) {
        this.replanningDate = date;
    }

    @Override
    public Boolean getInReplanning() {
        return this.inReplanning;
    }

    @Override
    public void setInReplanning(Boolean val) {
        this.inReplanning = val;
    }

    @Override
    public Long getReplanningVersion() {
        return this.replanningVersion;
    }

    @Override
    public void setReplanningVersion(Long version) {
        this.replanningVersion = version;
    }

    @Override
    public Boolean getInStreamMode() {
        return this.inStreamMode;
    }

    @Override
    public void setInStreamMode(Boolean streamMode) {
        this.inStreamMode = streamMode;
    }

    @Override
    public List<IPerson> getPersons() {
        return this.persons;
    }

    @Override
    public List<ITheme> getThemes() {
        return this.themes;
    }

    public void setThemes(List<ITheme> themes) {
        this.themes = themes;
    }

    @Override
    public List<IStage> getStages() {
        return this.stages;
    }

    public void setStages(List<IStage> stages) {
        this.stages = stages;
    }

    @Override
    public List<ITeam> getTeams() {
        return this.teams;
    }

    private void setTeams(List<ITeam> teams) {
        this.teams = teams;
    }

    @Override
    public List<IWorkItem> getWorkItems() {
        return this.workItems;
    }

    @Override
    public List<IWorkItem> getEpics() {
        return this.epics;
    }

    @Override
    public List<IWorkItem> getStories() {
        return this.stories;
    }

    @Override
    public Map<String, IWorkItem> getWorkItemMap() {
        throw new RuntimeException("No available on rest plan.");
    }

    @Override
    public IPlanConfiguration getPlanConfiguration() {
        throw new RuntimeException("Use custom queries to get the configuration!");
    }

    @Override
    public Optional<? extends SchedulingWorkItem> getWorkItem(final String id) {
        return Iterables.tryFind(this.workItems, (Predicate)new Predicate<IWorkItem>(){

            public boolean apply(@Nullable IWorkItem workItem) {
                return workItem.getId().equals(id);
            }
        });
    }

    private void setWorkItems(List<IWorkItem> epics) {
        this.workItems = epics;
    }

    @Override
    public void nullifyReplanningData() {
        this.replanningDate = null;
    }

    @Override
    public void clearReplanning(ActiveObjectsUtilities utils) {
        this.replanningDate = null;
    }

    @Override
    public void applyReplanning(ActiveObjectsUtilities utils, Long replanningDate) {
        if (replanningDate != null) {
            this.date = replanningDate;
        }
    }

    public void setTemplateType(String templateType) {
        this.template = templateType;
    }

    public void setAccessMode(String accessMode) {
        this.accessMode = accessMode;
    }
}

