/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling.cap;

import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.rest.entities.scheduling.cap.RestAssignmentEntry;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ISchedulingAssignment;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.ResourceSprintStatistic;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.math3.util.Precision;

@XmlRootElement(name="resourceIntervalData")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestResourceIntervalCapacity {
    @XmlElement
    String id;
    @XmlElement
    Double capacity;
    @XmlElement
    Set<RestAssignmentEntry> assignment;

    RestResourceIntervalCapacity(String id, double capacity, Set<RestAssignmentEntry> assignment) {
        this.id = id;
        this.capacity = capacity;
        this.assignment = assignment;
    }

    private RestResourceIntervalCapacity() {
    }

    static RestResourceIntervalCapacity create(ResourceSprintStatistic statistic) {
        return new RestResourceIntervalCapacity(statistic.getId(), Precision.round((double)statistic.getCapacity(), 2, 0), RestResourceIntervalCapacity.createStreamToPlanned(statistic));
    }

    private static Set<RestAssignmentEntry> createStreamToPlanned(ResourceSprintStatistic statistic) {
        HashSet entries = Sets.newHashSet();
        for (ISchedulingAssignment assignment : statistic.getSchedulingAssignments()) {
            entries.add(RestAssignmentEntry.create(assignment));
        }
        return entries;
    }
}

