/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.exceptions;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.dbutils.DbUtils;

@XmlRootElement(name="info")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestServerInfo {
    @XmlElement
    private String dbType;
    @XmlElement
    private String dbVersion;
    @XmlElement
    private String dbDriver;
    @XmlElement
    private String dbDriverVersion;
    @XmlElement
    private String jdbcVersion;

    private RestServerInfo() {
    }

    public static RestServerInfo empty() {
        return new RestServerInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RestServerInfo fromActiveObjects(ActiveObjectsUtilities activeObjectsUtilities) {
        RestServerInfo info = new RestServerInfo();
        Connection connection = null;
        try {
            connection = activeObjectsUtilities.getOrCreateConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            info.dbType = metaData.getDatabaseProductName();
            info.dbVersion = metaData.getDatabaseProductVersion() + " (" + metaData.getDatabaseMajorVersion() + "." + metaData.getDatabaseMinorVersion() + ")";
            info.dbDriver = metaData.getDriverName();
            info.dbDriverVersion = metaData.getDriverVersion() + " (" + metaData.getDriverMajorVersion() + "." + metaData.getDriverMinorVersion() + ")";
            info.jdbcVersion = metaData.getJDBCMajorVersion() + "." + metaData.getJDBCMinorVersion();
        }
        catch (Exception ex) {
            info.dbType = "Unable to get database connection information.";
        }
        finally {
            DbUtils.closeQuietly(connection);
        }
        return info;
    }
}

