/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.configuration;

import com.atlassian.pocketknife.api.querydsl.ConnectionProvider;
import com.google.common.collect.Iterables;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.INonWorkingDay;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.configuration.AONonWorkingDays;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.sql.TeamSQL;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioNonWorkingDaysPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.ContextAwareSecureService;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.EntityParam;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtils;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtilsCallback;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.plans.RestNonWorkingDay;
import com.radiantminds.roadmap.common.rest.entities.plans.RestPlanConfiguration;
import com.radiantminds.roadmap.common.rest.services.common.SchedulingRelevantPatchChecker;
import java.sql.Connection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/plans/{id}/config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ContextAwareSecureService
@Component
public class PlanConfigurationService {
    private final PortfolioPlanPersistence planPersistence;
    private final PortfolioNonWorkingDaysPersistence nonWorkingDaysPersistence;
    private final ActiveObjectsUtilities activeObjectsUtilities;
    private final SubCollectionUtils subCollectionUtils;
    private final ConnectionProvider connectionProvider;

    @Autowired
    public PlanConfigurationService(PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioNonWorkingDaysPersistence nonWorkingDaysPersistence, ActiveObjectsUtilities activeObjectsUtilities, ConnectionProvider connectionProvider) {
        this.planPersistence = planPersistence;
        this.nonWorkingDaysPersistence = nonWorkingDaysPersistence;
        this.activeObjectsUtilities = activeObjectsUtilities;
        this.subCollectionUtils = new SubCollectionUtils(activeObjectsUtilities, workItemPersistence);
        this.connectionProvider = connectionProvider;
    }

    @GET
    @AuthorizedPlanReadAccess
    public Response getPlanConfiguration(@EntityParam(value=PortfolioPlanPersistence.class) EntityContext<IPlan> entityContext) throws Exception {
        IPlanConfiguration config = this.planPersistence.getPlanConfiguration(entityContext.getEntityId());
        if (config instanceof RestPlanConfiguration) {
            ((RestPlanConfiguration)config).setNonWorkingDays(this.nonWorkingDaysPersistence.listForPlan(entityContext.getEntityId()));
        }
        return entityContext.ok(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On, incrementSchedulingVersion=VersionIncrementMode.Dynamic)
    @POST
    @Path(value="/patch")
    public Response patchPlanConfigurationWithPost(@EntityParam(value=PortfolioPlanPersistence.class) EntityContext<IPlan> entityContext, RestPlanConfiguration planConfiguration) throws Exception {
        TeamSQL teamSQL = new TeamSQL(this.activeObjectsUtilities);
        entityContext.setIncrementSchedulingVersion(SchedulingRelevantPatchChecker.test(planConfiguration));
        String planId = entityContext.getEntityId();
        if (PlanningUnit.STORY_POINTS.unit().equals(planConfiguration.getPlanningUnit())) {
            Connection conn = null;
            try {
                conn = this.connectionProvider.borrowConnection();
                if (!teamSQL.allTeamsInPlanUseScrum(planId, conn).booleanValue()) {
                    Response response = ResponseBuilder.badRequest(RestMessaging.warning("config-story-points-not-allowed"));
                    return response;
                }
            }
            finally {
                if (conn != null) {
                    this.connectionProvider.returnConnection(conn);
                }
            }
        }
        this.planPersistence.setPlanConfiguration(planId, planConfiguration);
        return entityContext.ok(new ModificationResult());
    }

    @AuthorizedPlanReadAccess
    @GET
    @Path(value="/nonworkingdays")
    public Response getAllNonWorkingDays(@EntityParam(value=PortfolioPlanPersistence.class) EntityContext<IPlan> entityContext) throws Exception {
        List<RestNonWorkingDay> intervals = this.nonWorkingDaysPersistence.listForPlan(entityContext.getEntityId());
        return entityContext.okForList(Iterables.toArray(intervals, RestNonWorkingDay.class));
    }

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On, incrementSchedulingVersion=VersionIncrementMode.On)
    @POST
    @Path(value="/nonworkingdays")
    public Response addNonWorkingDayToPlan(@EntityParam(value=PortfolioPlanPersistence.class) EntityContext<IPlan> entityContext, RestNonWorkingDay newNonWorkingDay) throws Exception {
        return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AONonWorkingDays.class, "plan", newNonWorkingDay, new SubCollectionUtilsCallback.Adapter<IPlan, INonWorkingDay, RestNonWorkingDay>(){

            @Override
            public void setParent(IPlan parent, INonWorkingDay entity) {
                entity.setPlan(parent);
            }

            @Override
            public INonWorkingDay persist(INonWorkingDay entity) throws Exception {
                return PlanConfigurationService.this.nonWorkingDaysPersistence.persist(entity);
            }

            @Override
            public INonWorkingDay get(String id) throws Exception {
                return (INonWorkingDay)PlanConfigurationService.this.nonWorkingDaysPersistence.get(id);
            }
        });
    }

    @AuthorizedPlanUserAccess(incrementPlanVersion=VersionIncrementMode.On, incrementSchedulingVersion=VersionIncrementMode.Off, incrementEntityVersion=VersionIncrementMode.Off)
    @PUT
    @Path(value="/nonworkingdays/rank")
    public Response rankNonWorkingDay(@EntityParam(value=PortfolioPlanPersistence.class) EntityContext<IPlan> entityContext, RestRank rank) throws Exception {
        return this.subCollectionUtils.rankEntity(entityContext, AONonWorkingDays.class, this.nonWorkingDaysPersistence, "plan", rank);
    }
}

