/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.errorreporting;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PlanExporter;
import com.radiantminds.roadmap.common.data.persistence.ao.port.PortProgress;
import com.radiantminds.roadmap.common.data.persistence.ao.port.XmlExportablePersistenceIndex;
import com.radiantminds.roadmap.common.extensions.communication.CommunicationExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPluginAdminAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPluginReadAccess;
import com.radiantminds.roadmap.common.rest.entities.errorreporting.RestErrorReport;
import com.radiantminds.roadmap.common.utils.meta.MetaDataUtils;
import java.util.ArrayList;
import javax.mail.internet.MimeBodyPart;
import javax.ws.rs.core.Response;

public interface ErrorReportingServiceHandler {
    @AuthorizedPlanReadAccess
    public Response reportErrorForPlan(EntityContext<IPlan> var1, boolean var2, RestErrorReport var3) throws Exception;

    @AuthorizedPluginReadAccess
    @AuthorizedPluginAdminAccess
    public Response reportError(RestErrorReport var1) throws Exception;

    public static class Impl
    implements ErrorReportingServiceHandler {
        private static final String FROM_MAIL = "noreply@atlassian.com";
        private static final String SUBJECT = "[Portfolio for JIRA] Automated Bug Report";
        private final PlanExporter planExporter;
        private final XmlExportablePersistenceIndex index;
        private final ActiveObjectsUtilities activeObjectsUtilities;
        private final CommunicationExtension communicationExtension;

        public Impl(XmlExportablePersistenceIndex index, ActiveObjectsUtilities activeObjectsUtilities, CommunicationExtension communicationExtension, MetaDataUtils metaDataUtils) {
            this.index = index;
            this.activeObjectsUtilities = activeObjectsUtilities;
            this.communicationExtension = communicationExtension;
            this.planExporter = new PlanExporter(activeObjectsUtilities, index, metaDataUtils);
        }

        @Override
        public Response reportErrorForPlan(EntityContext<IPlan> entityContext, boolean includePlan, RestErrorReport report) throws Exception {
            ArrayList attachments = Lists.newArrayList();
            if (includePlan) {
                String xml = this.planExporter.export(report.getPlanId(), new PortProgress(), false, false);
                MimeBodyPart planXml = new MimeBodyPart();
                planXml.setFileName("plan.xml");
                planXml.setContent((Object)xml, "application/xml");
                attachments.add(planXml);
            }
            this.communicationExtension.sendMail(FROM_MAIL, report.getFromName() + " via Portfolio for JIRA", report.getTo(), SUBJECT, report.getReport(), attachments);
            return Response.noContent().build();
        }

        @Override
        public Response reportError(RestErrorReport report) throws Exception {
            this.communicationExtension.sendMail(FROM_MAIL, report.getFromName() + " via Portfolio for JIRA", report.getTo(), SUBJECT, report.getReport(), Lists.newArrayList());
            return Response.noContent().build();
        }
    }
}

