/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.resources;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.people.IResource;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAvailabilityIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.people.RestAvailability;
import com.radiantminds.roadmap.common.rest.entities.people.RestResource;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsService;
import com.radiantminds.roadmap.common.rest.services.resources.ResourceServiceHandler;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/resources")
@Component
public class ResourceService
extends BaseOperationsService<IResource, RestResource> {
    private final ResourceServiceHandler handler;

    @Autowired
    public ResourceService(SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioWorkItemPersistence workItemPersistence, PortfolioResourcePersistence resourcePersistence, PortfolioAvailabilityIntervalPersistence availabilityIntervalPersistence) {
        super(RestResource.class, resourcePersistence, handlerFactory);
        this.handler = handlerFactory.createProxy(ResourceServiceHandler.class, new ResourceServiceHandler.Impl(activeObjectsUtilities, availabilityIntervalPersistence, workItemPersistence), resourcePersistence);
    }

    @Override
    protected RestResource transform(IResource entity, boolean includeReplanningData) {
        return new RestResource(entity);
    }

    @Override
    protected Response update(RestResource source, IResource target, boolean allowNull) {
        if (allowNull || source.getAvailability() != null) {
            Double val = source.getAvailability();
            if (val == null || val == -1.0) {
                val = null;
            }
            target.setAvailability(val);
        }
        return null;
    }

    @GET
    @Path(value="{id}/availabilities")
    public Response getAllAvailabilities(@PathParam(value="id") String resourceId, @QueryParam(value="planVersion") Long expectedPlanVersion) throws Exception {
        return this.handler.getAllAvailabilities(EntityContext.from(resourceId, expectedPlanVersion));
    }

    @POST
    @Path(value="{id}/availabilities")
    public Response addAvailabilityToResoure(@PathParam(value="id") String resourceId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestAvailability newAvailability) throws Exception {
        return this.handler.addAvailabilityToResource(EntityContext.from(resourceId, expectedPlanVersion, clientId), newAvailability);
    }

    @PUT
    @Path(value="{id}/availabilities/rank")
    public Response rankResource(@PathParam(value="id") String resourceId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestRank rank) throws Exception {
        return this.handler.rankAvailability(EntityContext.from(resourceId, expectedPlanVersion, clientId), rank);
    }
}

