/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.system;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.extensions.workitems.IIssueRequest;
import com.radiantminds.roadmap.common.rest.services.system.entities.RestImportRequest;
import java.sql.SQLException;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IssueRequest
implements IIssueRequest {
    private static final long DEFAULT_LIMIT = 100L;
    private final String query;
    private final Set<String> excludedLinks;
    private final long resultsLimit;
    private boolean epicFetchEnabled;
    private final IIssueRequest.EstimationMethod estimationMethod;

    private IssueRequest(String query, Set<String> excludedLinks, long resultsLimit, boolean epicFetchEnabled, IIssueRequest.EstimationMethod estimationMethod) {
        this.query = query;
        this.excludedLinks = excludedLinks;
        this.resultsLimit = resultsLimit;
        this.epicFetchEnabled = epicFetchEnabled;
        this.estimationMethod = estimationMethod;
    }

    public static IssueRequest create(String query, IIssueRequest.EstimationMethod estimationMethod) {
        return new IssueRequest(query, Sets.newHashSet(), 100L, false, estimationMethod);
    }

    public static IssueRequest createFromRestImportRequest(RestImportRequest request, PortfolioExtensionLinkPersistence extensionLinkEntityPersistence) throws SQLException {
        String queryString = request.getQuery();
        long limit = (Long)Objects.firstNonNull((Object)request.getMaxResults(), (Object)100L);
        boolean epicFetch = request.isEpicFetchEnabled();
        IIssueRequest.EstimationMethod estimationMethod = null;
        if ("storypoints".equals(request.getEstimationMethod())) {
            if (Boolean.TRUE.equals(request.isLoadStoryPoints())) {
                estimationMethod = IIssueRequest.EstimationMethod.STORY_POINTS;
            }
        } else {
            estimationMethod = IIssueRequest.EstimationMethod.ESTIMATES;
        }
        Set<String> excluded = IssueRequest.getExcludedLinks(request, extensionLinkEntityPersistence);
        return new IssueRequest(queryString, excluded, limit, epicFetch, estimationMethod);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public Set<String> getExcludedLinks() {
        return this.excludedLinks;
    }

    @Override
    public long getResultsLimit() {
        return this.resultsLimit;
    }

    @Override
    public boolean isEpicFetchEnabled() {
        return this.epicFetchEnabled;
    }

    @Override
    public IIssueRequest.EstimationMethod getEstimationMethod() {
        return this.estimationMethod;
    }

    private static Set<String> getExcludedLinks(RestImportRequest request, PortfolioExtensionLinkPersistence extensionLinkEntityPersistence) throws SQLException {
        if (Boolean.TRUE.equals(request.isExcludeLinked())) {
            return extensionLinkEntityPersistence.getLinksForPlan(request.getPlanId());
        }
        return Sets.newHashSet();
    }
}

