/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.teams.velocity;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.LinearTeamVelocityFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TeamVelocitySupplyWrapper;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import com.google.common.base.Objects;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.plans.FullContentSchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.plans.PersonMapping;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingConfig;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.EntityNotFoundException;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.RestDoubleArray;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.people.RestVelocitySettings;
import com.radiantminds.roadmap.common.rest.services.teams.velocity.PersonMappingImpl;
import com.radiantminds.roadmap.common.scheduling.common.TimeTransformer;
import com.radiantminds.roadmap.common.scheduling.entities.SchedulingPlanFactory;
import com.radiantminds.roadmap.common.scheduling.trafo.WorkDayPresenceFunctionFactory;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.ScrumSprintTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.point.AdjustedResourceRatioSupplyFunctionCreator;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.point.ResourceRatioSupplyFunctionCreator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

public interface TeamVelocityServiceHandler {
    @AuthorizedPlanUserAccess(incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.On)
    public Response setVelocitySettings(EntityContext<ITeam> var1, RestVelocitySettings var2) throws Exception;

    @AuthorizedPlanReadAccess(entityNeeded=true)
    public Response getVelocityForecast(EntityContext<ITeam> var1, int var2, Double var3, Double var4, boolean var5) throws Exception;

    public static class Impl
    implements TeamVelocityServiceHandler {
        private static final Log LOGGER = Log.with(TeamVelocityServiceHandler.class);
        private final PortfolioTeamPersistence teamPersistence;
        private final SchedulingPlanFactory schedulingPlanFactory;

        public Impl(PortfolioTeamPersistence teamPersistence, SchedulingPlanFactory schedulingPlanFactory) {
            this.teamPersistence = teamPersistence;
            this.schedulingPlanFactory = schedulingPlanFactory;
        }

        @Override
        public Response setVelocitySettings(EntityContext<ITeam> entityContext, RestVelocitySettings suppliedVelocitySettings) throws Exception {
            RestVelocitySettings velocitySettings = (RestVelocitySettings)Objects.firstNonNull((Object)suppliedVelocitySettings, (Object)new RestVelocitySettings(null, null, null));
            this.teamPersistence.updateVelocitySettings(entityContext.getEntityId(), velocitySettings.getVelocity(), velocitySettings.getIncrementalAdjustment(), velocitySettings.getAutoAdjustToAbsences());
            return entityContext.okForEntityUpdate();
        }

        @Override
        public Response getVelocityForecast(EntityContext<ITeam> entityContext, int count, Double velocity, Double increment, boolean adjustToAbsences) throws Exception {
            String teamId = entityContext.getEntityId();
            LOGGER.debug("get velocity forecast for team: %s", teamId);
            FullContentSchedulingPlan plan = this.schedulingPlanFactory.create(entityContext.getEntityInfo().getPlanId());
            if (plan == null) {
                return ResponseBuilder.badRequest(RestMessaging.entityNotFound());
            }
            SchedulingTeam team = this.tryGetTeam(teamId, plan);
            TimeTransformer timeTransformer = TimeTransformer.createFromPlan(plan);
            TimeStepPresenceFunction presenceFunction = WorkDayPresenceFunctionFactory.createForPlan(timeTransformer, plan);
            ScrumSprintTransformer sprintTransformer = new ScrumSprintTransformer(timeTransformer, presenceFunction);
            WorkSlotsDefinition scrumSlots = sprintTransformer.createWorkSlotDefinition(team, plan.getPlanConfiguration().getGlobalSprintLength());
            if (team.getResources() == null || team.getResources().isEmpty()) {
                LOGGER.debug("create forecast for empty team", new Object[0]);
                LinearTeamVelocityFunction function = new LinearTeamVelocityFunction(Impl.getVelocity(velocity, plan.getPlanConfiguration()), Impl.getIncrement(increment), scrumSlots, presenceFunction);
                TeamVelocitySupplyWrapper wrapper = new TeamVelocitySupplyWrapper(function, scrumSlots);
                double[] velocities = new double[count];
                for (int i = 0; i < velocities.length; ++i) {
                    velocities[i] = wrapper.getUnassignedWorkInWorkSlot(i);
                }
                RestDoubleArray entity = new RestDoubleArray(velocities);
                return Response.ok((Object)entity).build();
            }
            if (adjustToAbsences) {
                LOGGER.debug("create availability based forecast", new Object[0]);
                AdjustedResourceRatioSupplyFunctionCreator transformer = new AdjustedResourceRatioSupplyFunctionCreator(timeTransformer, presenceFunction);
                PersonMapping personMapping = PersonMappingImpl.create(team.getResources(), plan);
                Map<SchedulingResource, IWorkSlotFunction> resourceSupplyFunctions = transformer.getResourceSupplyFunctions(team.getResources(), personMapping, scrumSlots, Impl.getVelocity(velocity, plan.getPlanConfiguration()), Impl.getIncrement(increment));
                double[] velocities = new double[count];
                for (int i = 0; i < velocities.length; ++i) {
                    double sum = 0.0;
                    for (IWorkSlotFunction slotFunction : resourceSupplyFunctions.values()) {
                        sum += (double)slotFunction.getUnassignedWorkInWorkSlot(i);
                    }
                    velocities[i] = sum;
                }
                RestDoubleArray entity = new RestDoubleArray(velocities);
                return Response.ok((Object)entity).build();
            }
            ResourceRatioSupplyFunctionCreator transformer = new ResourceRatioSupplyFunctionCreator(timeTransformer, presenceFunction);
            PersonMapping personMapping = PersonMappingImpl.create(team.getResources(), plan);
            Map<SchedulingResource, IWorkSlotFunction> resourceSupplyFunctions = transformer.getResourceSupplyFunctions(team, personMapping, scrumSlots, Impl.getVelocity(velocity, plan.getPlanConfiguration()), Impl.getIncrement(increment));
            double[] velocities = new double[count];
            for (int i = 0; i < velocities.length; ++i) {
                double sum = 0.0;
                for (IWorkSlotFunction slotFunction : resourceSupplyFunctions.values()) {
                    sum += (double)slotFunction.getUnassignedWorkInWorkSlot(i);
                }
                velocities[i] = sum;
            }
            RestDoubleArray entity = new RestDoubleArray(velocities);
            return Response.ok((Object)entity).build();
        }

        private SchedulingTeam tryGetTeam(String teamId, SchedulingPlan plan) throws EntityNotFoundException {
            SchedulingTeam team = null;
            for (SchedulingTeam schedulingTeam : plan.getTeams()) {
                if (!teamId.equals(schedulingTeam.getId())) continue;
                team = schedulingTeam;
            }
            if (team == null) {
                throw new EntityNotFoundException();
            }
            return team;
        }

        private static float getIncrement(@Nullable Double increment) {
            if (increment != null) {
                return increment.floatValue();
            }
            return 0.0f;
        }

        private static float getVelocity(@Nullable Double velocity, SchedulingConfig planConfiguration) {
            if (velocity != null) {
                return velocity.floatValue();
            }
            return planConfiguration.getGlobalDefaultVelocity().floatValue();
        }
    }
}

