/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.estimates;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.DefaultEstimateExtractor;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSkillPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.issues.IssueSyncData;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimate;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.WorkItemConstraintChecker;
import javax.ws.rs.core.Response;

public interface WorkItemEstimateServiceHandler {
    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Dynamic)
    public Response setSkillEstimate(EntityContext<IWorkItem> var1, String var2, RestEstimate var3, DataMode var4) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Dynamic)
    public Response setStageEstimate(EntityContext<IWorkItem> var1, String var2, RestEstimate var3, DataMode var4) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Dynamic)
    public Response setTotalEstimate(EntityContext<IWorkItem> var1, RestEstimate var2, DataMode var3) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response setCurrentEstimatesAsOriginalEstimates(EntityContext<IWorkItem> var1) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response deleteOriginalEstimates(EntityContext<IWorkItem> var1) throws Exception;

    public static class Impl
    implements WorkItemEstimateServiceHandler {
        private final PortfolioEstimatePersistence estimatePersistence;
        private final PortfolioSkillPersistence skillPersistence;
        private final PortfolioStagePersistence stagePersistence;
        private final PortfolioToJiraSyncExtension portfolioToJiraSyncExtension;
        private final WorkItemConstraintChecker workItemConstraintChecker;
        private final DefaultEstimateExtractor defaultEstimateExtractor;

        public Impl(PortfolioEstimatePersistence estimatePersistence, PortfolioStagePersistence stagePersistence, PortfolioSkillPersistence skillPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioPlanPersistence planPersistence, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension) {
            this.estimatePersistence = estimatePersistence;
            this.stagePersistence = stagePersistence;
            this.skillPersistence = skillPersistence;
            this.portfolioToJiraSyncExtension = portfolioToJiraSyncExtension;
            this.workItemConstraintChecker = new WorkItemConstraintChecker(workItemPersistence);
            this.defaultEstimateExtractor = new DefaultEstimateExtractor(workItemPersistence, planPersistence);
        }

        @Override
        public Response setSkillEstimate(final EntityContext<IWorkItem> entityContext, final String skillId, final RestEstimate estimate, final DataMode dataMode) throws Exception {
            entityContext.setIncrementSchedulingVersion(dataMode == DataMode.Default);
            return Impl.setEstimateForWorkItem(entityContext, new EstimationServiceUtilCallback(){

                @Override
                public Response preOperationChecks() throws Exception {
                    String constraintCheck = workItemConstraintChecker.isAssignable(entityContext.getEntityId());
                    if (constraintCheck != null) {
                        return ResponseBuilder.badRequest(RestMessaging.error(constraintCheck));
                    }
                    if (dataMode == DataMode.Original && !estimatePersistence.hasOriginalEstimates(entityContext.getEntityId())) {
                        return ResponseBuilder.badRequest(RestMessaging.error("Work item doesn't have original estimates!"));
                    }
                    if (!skillPersistence.exists(skillId)) {
                        return ResponseBuilder.badRequest(RestMessaging.entityNotFound());
                    }
                    return null;
                }

                @Override
                public void call() throws Exception {
                    estimatePersistence.setSkillEstimate(entityContext.getEntityId(), skillId, estimate, dataMode);
                    if (dataMode != DataMode.Replanning) {
                        this.triggerSyncToJira(entityContext);
                    }
                }
            });
        }

        @Override
        public Response setStageEstimate(final EntityContext<IWorkItem> entityContext, final String stageId, final RestEstimate estimate, final DataMode dataMode) throws Exception {
            entityContext.setIncrementSchedulingVersion(dataMode == DataMode.Default);
            return Impl.setEstimateForWorkItem(entityContext, new EstimationServiceUtilCallback(){

                @Override
                public Response preOperationChecks() throws Exception {
                    String constraintCheck = workItemConstraintChecker.isAssignable(entityContext.getEntityId());
                    if (constraintCheck != null) {
                        return ResponseBuilder.badRequest(RestMessaging.error(constraintCheck));
                    }
                    if (dataMode == DataMode.Original && !estimatePersistence.hasOriginalEstimates(entityContext.getEntityId())) {
                        return ResponseBuilder.badRequest(RestMessaging.error("Work item doesn't have original estimates!"));
                    }
                    if (!stagePersistence.exists(stageId)) {
                        return ResponseBuilder.badRequest(RestMessaging.entityNotFound());
                    }
                    return null;
                }

                @Override
                public void call() throws Exception {
                    estimatePersistence.setStageEstimate(entityContext.getEntityId(), stageId, estimate, dataMode);
                    if (dataMode != DataMode.Replanning) {
                        this.triggerSyncToJira(entityContext);
                    }
                }
            });
        }

        @Override
        public Response setTotalEstimate(final EntityContext<IWorkItem> entityContext, final RestEstimate estimate, final DataMode dataMode) throws Exception {
            entityContext.setIncrementSchedulingVersion(dataMode == DataMode.Default);
            return Impl.setEstimateForWorkItem(entityContext, new EstimationServiceUtilCallback(){

                @Override
                public Response preOperationChecks() throws Exception {
                    String constraintCheck = workItemConstraintChecker.isAssignable(entityContext.getEntityId());
                    if (constraintCheck != null) {
                        return ResponseBuilder.badRequest(RestMessaging.error(constraintCheck));
                    }
                    if (dataMode == DataMode.Original && !estimatePersistence.hasOriginalEstimates(entityContext.getEntityId())) {
                        return ResponseBuilder.badRequest(RestMessaging.error("Work item doesn't have original estimates!"));
                    }
                    return null;
                }

                @Override
                public void call() throws Exception {
                    estimatePersistence.setTotalEstimate(entityContext.getEntityId(), estimate, dataMode);
                    if (dataMode != DataMode.Replanning) {
                        this.triggerSyncToJira(entityContext);
                    }
                }
            });
        }

        @Override
        public Response setCurrentEstimatesAsOriginalEstimates(EntityContext<IWorkItem> entityContext) throws Exception {
            String constraintCheck = this.workItemConstraintChecker.isAssignable(entityContext.getEntityId());
            if (constraintCheck != null) {
                return ResponseBuilder.badRequest(RestMessaging.error(constraintCheck));
            }
            this.estimatePersistence.clearOriginalEstimates(entityContext.getEntityId());
            String entityId = entityContext.getEntityId();
            Optional<Double> defaultEstimate = this.defaultEstimateExtractor.defaultEstimateForWorkItem(entityId);
            this.estimatePersistence.copyCurrentToOriginalEstimates(entityId, defaultEstimate, true);
            this.triggerSyncToJira(entityContext);
            return entityContext.okForEntityUpdate();
        }

        @Override
        public Response deleteOriginalEstimates(EntityContext<IWorkItem> entityContext) throws Exception {
            String constraintCheck = this.workItemConstraintChecker.isAssignable(entityContext.getEntityId());
            if (constraintCheck != null) {
                return ResponseBuilder.badRequest(RestMessaging.error(constraintCheck));
            }
            this.estimatePersistence.clearOriginalEstimates(entityContext.getEntityId());
            this.triggerSyncToJira(entityContext);
            return entityContext.okForEntityUpdate();
        }

        private void triggerSyncToJira(EntityContext<IWorkItem> entityContext) {
            this.portfolioToJiraSyncExtension.syncWorkItemToIssues(IssueSyncData.createEstimateSyncFor(entityContext.getEntityId()));
        }

        private static Response setEstimateForWorkItem(EntityContext<IWorkItem> entityContext, EstimationServiceUtilCallback callback) throws Exception {
            Response preOperationCheckResult = callback.preOperationChecks();
            if (preOperationCheckResult != null) {
                return preOperationCheckResult;
            }
            callback.call();
            return entityContext.okForEntityUpdate();
        }

        private static interface EstimationServiceUtilCallback {
            public void call() throws Exception;

            public Response preOperationChecks() throws Exception;
        }
    }
}

