/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.stats;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.RmSchedulingUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class OverbookedWorkCalculator {
    private static final Log LOGGER = Log.with(OverbookedWorkCalculator.class);

    OverbookedWorkCalculator() {
    }

    Double calculateOverbookedWork(IEpisodeSchedule schedule, double workLoad) {
        LOGGER.debug("calculate overbooked work for schedule: %s", schedule);
        if (!schedule.isDelayed()) {
            LOGGER.debug("schedule is not delayed", new Object[0]);
            return null;
        }
        int fixedEnd = (Integer)schedule.getEpisode().getFixedEndTime().get();
        IntegerInterval inTimeInterval = new IntegerInterval(0, fixedEnd);
        Set<IWorkAssignment> slotsInTime = RmUtils.getContainedIntervals(inTimeInterval, schedule.getWorkAssignments());
        double workInTime = RmSchedulingUtils.getWorkLoadSum(slotsInTime);
        double overbooked = workLoad - workInTime;
        LOGGER.debug("overbooked work amount: %s", overbooked);
        return overbooked;
    }
}

