/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IWorkSlotData;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.GroupIntervalCapacityStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.ResourceIntervalCapacityStatistic;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class GroupIntervalStatisticImpl
implements GroupIntervalCapacityStatistic {
    private final IWorkSlot slot;
    private final List<IResourceType> bottlenecks;
    private final Set<ResourceIntervalCapacityStatistic> resourceCapacities;
    private final List<IResourceType> freeCapacities;
    private final IWorkSlotData workSlotData;

    public GroupIntervalStatisticImpl(IWorkSlot slot, IWorkSlotData workSlotData, Set<ResourceIntervalCapacityStatistic> resourceCapacities) {
        this.slot = slot;
        this.bottlenecks = Collections.unmodifiableList(workSlotData.getPriorizedBottleneckResourceTypes());
        this.freeCapacities = Collections.unmodifiableList(workSlotData.getFreeCapacitiesOfResourceTypes());
        this.resourceCapacities = Collections.unmodifiableSet(resourceCapacities);
        this.workSlotData = workSlotData;
    }

    @Override
    public int getStart() {
        return this.slot.getStart();
    }

    @Override
    public int getEnd() {
        return this.slot.getEnd();
    }

    @Override
    public List<IResourceType> getBottleneckTypes() {
        return this.bottlenecks;
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getBottleneckWeights() {
        return this.workSlotData.getBottleneckWeights();
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getFreeWeights() {
        return this.workSlotData.getFreeTypes();
    }

    @Override
    public Set<ResourceIntervalCapacityStatistic> getResourceIntervalCapacityStatistics() {
        return this.resourceCapacities;
    }

    @Override
    public int getIndex() {
        return this.slot.getIndex();
    }

    @Override
    public List<IResourceType> getFreeCapacities() {
        return this.freeCapacities;
    }
}

