/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.release;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.EpisodeStream;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisodeStream;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.releases.SchedulingRelease;
import com.radiantminds.roadmap.common.data.entities.releases.SchedulingStream;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.release.ReleaseTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StreamTransformer {
    private final ReleaseTransformer releaseTransformer;

    StreamTransformer(ReleaseTransformer releaseTransformer) {
        this.releaseTransformer = releaseTransformer;
    }

    public StreamTransformer(ITimeTransformer timeTransformer) {
        this(new ReleaseTransformer(timeTransformer));
    }

    IEpisodeStream transform(SchedulingStream stream, Set<String> availableResourceGroupIds) {
        List<IEpisode> episodes = this.transform(stream.getReleases(), stream.getLaterRelease(), stream.getId());
        Set<String> assignableGroupIds = this.getAssignableGroupIds(stream, availableResourceGroupIds);
        EpisodeStream episodeStream = new EpisodeStream(stream.getId(), episodes, assignableGroupIds);
        return episodeStream;
    }

    private Set<String> getAssignableGroupIds(SchedulingStream stream, Set<String> availableResourceGroupIds) {
        Set<String> teamRestriction = stream.getTeams();
        if (teamRestriction == null || teamRestriction.isEmpty()) {
            return availableResourceGroupIds;
        }
        return Sets.intersection(teamRestriction, availableResourceGroupIds);
    }

    private List<IEpisode> transform(List<? extends SchedulingRelease> specifiedReleases, SchedulingRelease laterRelease, String streamId) {
        ArrayList episodes = Lists.newArrayList();
        ArrayList releases = Lists.newArrayList(specifiedReleases);
        releases.add(laterRelease);
        for (int i = 0; i < releases.size(); ++i) {
            SchedulingRelease release = (SchedulingRelease)releases.get(i);
            IEpisode episode = (IEpisode)this.releaseTransformer.transform(release, releases, streamId).get();
            episodes.add(episode);
        }
        return episodes;
    }
}

