/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.utils.estimate;

import com.google.common.base.Objects;
import com.radiantminds.roadmap.common.utils.estimate.EstimateData;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class EstimateDataAdaptions {
    EstimateDataAdaptions() {
    }

    public static void storeStageValues(EstimateData parentNode, Map<String, Double> changes) {
        for (EstimateData node : parentNode.getSubEstimates()) {
            changes.put(node.getId(), node.getSelfValue());
        }
    }

    public static void adaptProportionally(List<EstimateData> nodes, double targetValue, Map<String, Double> changes, @Nullable NodeAdaptionFunction nextLevelFunction) {
        for (EstimateData node : nodes) {
            double nodeTargetValue = node.getPercentOfSum() * targetValue;
            EstimateDataAdaptions.setNodeValue(node, nodeTargetValue, changes, nextLevelFunction);
        }
    }

    public static void decrementNodeByNode(EstimateData parentNode, double targetValue, Map<String, Double> changes, @Nullable NodeAdaptionFunction nextLevelFunction) {
        double remainingEstimateToReduce = parentNode.getSum() - targetValue;
        for (EstimateData node : parentNode.getSubEstimates()) {
            double currentNodeValue = (Double)Objects.firstNonNull((Object)node.getSelfValue(), (Object)node.getSum());
            double targetNodeValue = Math.max(0.0, currentNodeValue - remainingEstimateToReduce);
            EstimateDataAdaptions.setNodeValue(node, targetNodeValue, changes, nextLevelFunction);
            if ((remainingEstimateToReduce -= currentNodeValue - targetNodeValue) != 0.0) continue;
            break;
        }
    }

    public static void setNodesToValues(List<EstimateData> nodes, Map<String, Double> valuePerItem, Map<String, Double> changes, @Nullable NodeAdaptionFunction nextLevelFunction) {
        for (EstimateData node : nodes) {
            Double value = valuePerItem.get(node.getId());
            if (value == null) continue;
            EstimateDataAdaptions.setNodeValue(node, value, changes, nextLevelFunction);
        }
    }

    private static void setNodeValue(EstimateData node, double targetValue, Map<String, Double> changes, @Nullable NodeAdaptionFunction nextLevelFunction) {
        if (node.getSelfValue() != null || node.getSum() == 0.0) {
            double selfValue = (Double)Objects.firstNonNull((Object)node.getSelfValue(), (Object)0.0);
            if (selfValue != targetValue) {
                changes.put(node.getId(), targetValue);
            }
        } else if (nextLevelFunction != null) {
            nextLevelFunction.adaptSubNodes(node, targetValue);
        }
    }

    public static interface NodeAdaptionFunction {
        public void adaptSubNodes(EstimateData var1, double var2);
    }
}

