/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.pocketknife.api.querydsl.ConnectionProvider;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioConfigurationPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPermissionPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.licenses.LicenseExtension;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.jira.common.components.init.LaunchStateService;
import com.radiantminds.roadmap.jira.common.components.issues.IssueEventWrapper;
import com.radiantminds.roadmap.jira.common.components.issues.JiraIssueEventHandler;
import com.radiantminds.roadmap.jira.common.components.issues.SyncableFields;
import com.radiantminds.roadmap.jira.common.components.sync.SynchronizationFlagHandler;
import com.radiantminds.roadmap.jira.common.components.utils.DefaultPermissionService;
import com.radiantminds.roadmap.jira.common.components.utils.DevelopmentMode;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class PortfolioAwesomeLauncher
implements LifecycleAware,
InitializingBean,
DisposableBean {
    private static final Log LOGGER = Log.with(PortfolioAwesomeLauncher.class);
    public static final String PLUGIN_KEY = "com.radiantminds.roadmaps-jira";
    private final EventPublisher eventPublisher;
    private final ActiveObjects ao;
    private final JiraIssueEventHandler jiraIssueEventHandler;
    private final GroupManager groupManager;
    private final PortfolioPermissionPersistence permissionPersistence;
    private final PortfolioConfigurationPersistence configurationPersistence;
    private final LicenseExtension licenseExtension;
    private final DefaultPermissionService defaultPermissionService;
    private final LaunchStateService launchStateService;
    @GuardedBy(value="this")
    private final Set<LifecycleEvent> lifecycleEvents = EnumSet.noneOf(LifecycleEvent.class);

    public PortfolioAwesomeLauncher(EventPublisher eventPublisher, ActiveObjects ao, GroupManager groupManager, SyncableFields syncableFields, ConnectionProvider connectionProvider, PortfolioPlanPersistence planPersistence, PortfolioPermissionPersistence permissionPersistence, PortfolioConfigurationPersistence configurationPersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, WorkItemExtension workItemExtension, LicenseExtension licenseExtension, DefaultPermissionService defaultPermissionService, ApplicationProperties applicationProperties, SynchronizationFlagHandler flagHandler, LaunchStateService launchStateService) {
        this.defaultPermissionService = defaultPermissionService;
        this.launchStateService = launchStateService;
        if (DevelopmentMode.isOn()) {
            Log.with("com.radiantminds").setInfoLogLevel();
        }
        this.eventPublisher = eventPublisher;
        this.ao = ao;
        this.groupManager = groupManager;
        this.permissionPersistence = permissionPersistence;
        this.configurationPersistence = configurationPersistence;
        this.licenseExtension = licenseExtension;
        this.jiraIssueEventHandler = new JiraIssueEventHandler(flagHandler, connectionProvider, workItemPersistence, estimatePersistence, planPersistence, extensionLinkPersistence, workItemExtension, applicationProperties, syncableFields);
    }

    public void afterPropertiesSet() {
        this.registerListener();
        this.onLifecycleEvent(LifecycleEvent.AFTER_PROPERTIES_SET);
    }

    public void onStart() {
        this.onLifecycleEvent(LifecycleEvent.LIFECYCLE_AWARE_ON_START);
    }

    public void onStop() {
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            this.onLifecycleEvent(LifecycleEvent.PLUGIN_ENABLED);
        }
    }

    private void onLifecycleEvent(LifecycleEvent event) {
        LOGGER.info("Got Lifecycle event: " + (Object)((Object)event), new Object[0]);
        if (this.isLifecycleReady(event)) {
            LOGGER.info("Got the last lifecycle event... Time to get started!", new Object[0]);
            try {
                this.launch();
                this.launchStateService.setLaunched();
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error during launch", new Object[0]);
                LOGGER.exception(ex, Log.LogLevel.ERROR);
            }
        }
    }

    private synchronized boolean isLifecycleReady(LifecycleEvent event) {
        return this.lifecycleEvents.add(event) && this.isLifecycleReady();
    }

    private synchronized boolean isLifecycleReady() {
        return this.lifecycleEvents.size() == LifecycleEvent.values().length;
    }

    private void launch() throws Exception {
        LOGGER.info("", new Object[0]);
        LOGGER.info("=======================================", new Object[0]);
        LOGGER.info("=== Lauching Portfolio for JIRA ... ===", new Object[0]);
        LOGGER.info("=======================================", new Object[0]);
        LOGGER.info("", new Object[0]);
        this.initActiveObjects();
        this.initConfiguration();
        LOGGER.info("", new Object[0]);
        LOGGER.info("================================================", new Object[0]);
        LOGGER.info("=== Portfolio for JIRA launched successfully ===", new Object[0]);
        LOGGER.info("================================================", new Object[0]);
        LOGGER.info("", new Object[0]);
    }

    public void destroy() throws Exception {
        this.unregisterListener();
    }

    private void registerListener() {
        LOGGER.info("Registering eventPublisher listener", new Object[0]);
        this.eventPublisher.register((Object)this);
    }

    private void unregisterListener() {
        LOGGER.info("Unregistering eventPublisher listener", new Object[0]);
        this.eventPublisher.unregister((Object)this);
    }

    private void initActiveObjects() {
        LOGGER.info("Initalizing ActiveObjects", new Object[0]);
        this.ao.flushAll();
    }

    private void initConfiguration() {
        try {
            LOGGER.info("Initializing Portfolio configurations...", new Object[0]);
            boolean initialized = this.configurationPersistence.isInitialized();
            if (!initialized) {
                LOGGER.info("Configuring for new instance...", new Object[0]);
                this.defaultPermissionService.setDefaultEditorPermissions();
                this.defaultPermissionService.setDefaultLabsPermissions();
                this.configurationPersistence.initialize();
                this.configurationPersistence.setInitState(1);
                LOGGER.info("Configurations successfully initialized.", new Object[0]);
            } else {
                boolean licensed = this.licenseExtension.getLicenseData().isValid();
                if (!licensed) {
                    Optional<Integer> initState = this.configurationPersistence.getInitState();
                    if (!initState.isPresent() || (Integer)initState.get() < 1) {
                        LOGGER.info("Configuring for updated unlicensed instance...", new Object[0]);
                        this.defaultPermissionService.setDefaultEditorPermissions();
                        this.defaultPermissionService.setDefaultLabsPermissions();
                        this.configurationPersistence.setInitState(1);
                        LOGGER.info("Configurations successfully initialized.", new Object[0]);
                    }
                } else {
                    LOGGER.info("Configurations have already been initialized.", new Object[0]);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to initialize Portfolio configuration, plugin system not ready yet.", new Object[0]);
            LOGGER.exception(ex);
        }
    }

    @EventListener
    public void onIssueEvent(IssueEvent issueEvent) {
        if (!this.isLifecycleReady()) {
            LOGGER.info("IssueEvent received by Portfolio for JIRA, but the plugin is still in startup. Event will be ignored.", new Object[0]);
            return;
        }
        Long eventTypeId = issueEvent.getEventTypeId();
        if (eventTypeId.equals(EventType.ISSUE_UPDATED_ID)) {
            this.jiraIssueEventHandler.handleIssueUpdatedEvent(new IssueEventWrapper(issueEvent));
        } else if (eventTypeId.equals(EventType.ISSUE_DELETED_ID)) {
            Issue issue = issueEvent.getIssue();
            this.jiraIssueEventHandler.handleIssueDeleted(issue.getKey());
        }
    }

    static enum LifecycleEvent {
        AFTER_PROPERTIES_SET,
        PLUGIN_ENABLED,
        LIFECYCLE_AWARE_ON_START;

    }
}

