/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.rm.common.bridges.jira.lucene.JiraLuceneQueryUtilitiesProxy;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.IssueHierarchyResult;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.LuceneHierarchyResult;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import java.util.Set;
import org.apache.lucene.search.IndexSearcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LuceneJiraIssueAccessor {
    private final SearchProviderFactory searchProviderFactory;
    private final CustomFields customFields;
    private final StatusManager statusManager;
    private final ApplicationProperties applicationProperties;
    private final FieldManager fieldManager;
    private final JiraLuceneQueryUtilitiesProxy jiraLuceneQueryUtilities;

    @Autowired
    public LuceneJiraIssueAccessor(SearchProviderFactory searchProviderFactory, CustomFields customFields, StatusManager statusManager, ApplicationProperties applicationProperties, FieldManager fieldManager, JiraLuceneQueryUtilitiesProxy jiraLuceneQueryUtilities) {
        this.searchProviderFactory = searchProviderFactory;
        this.customFields = customFields;
        this.statusManager = statusManager;
        this.applicationProperties = applicationProperties;
        this.fieldManager = fieldManager;
        this.jiraLuceneQueryUtilities = jiraLuceneQueryUtilities;
    }

    IssueHierarchyResult retrieveFullHierarchy(Set<String> jpoKeys) throws Exception {
        IndexSearcher indexSearcher = this.searchProviderFactory.getSearcher("issues");
        return LuceneHierarchyResult.extract(indexSearcher, this.fieldManager, this.jiraLuceneQueryUtilities, this.customFields, this.statusManager, this.applicationProperties, jpoKeys);
    }
}

