/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress;

import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.common.extensions.workitems.StatusData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.JiraLinkEnrichmentData;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
class ExtensionLinkProgress
implements ProgressData {
    private final double percentage;
    private final double sum;
    private final boolean done;

    ExtensionLinkProgress(double percentage, double sum, boolean done) {
        this.percentage = percentage;
        this.sum = sum;
        this.done = done;
    }

    @Override
    public double getDonePercentage() {
        return this.percentage;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    static ExtensionLinkProgress createTimeBasedSelfProgress(JiraLinkEnrichmentData issuData, boolean handleDoneAs100Percent) {
        boolean statusDone = issuData.isDone();
        double donePercentage = issuData.getTimeDonePercentage();
        if (statusDone && handleDoneAs100Percent) {
            donePercentage = 1.0;
        }
        return new ExtensionLinkProgress(donePercentage, issuData.getTimeSumOrZero(), statusDone);
    }

    static ProgressData createResolutionSelfProgress(StatusData status) {
        boolean itemDone = status.isDone();
        if (itemDone) {
            return new ExtensionLinkProgress(1.0, 1.0, true);
        }
        return new ExtensionLinkProgress(0.0, 1.0, false);
    }

    static ProgressData createValueBasedSelfProgress(StatusData status, @Nullable Double value) {
        double percentage = 0.0;
        if (status.isDone()) {
            percentage = 1.0;
        }
        if (value == null || value <= 0.0) {
            value = 0.0;
        }
        return new ExtensionLinkProgress(percentage, value, status.isDone());
    }
}

