/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.links;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.Direction;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridge;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.issue.link.IssueLinkServiceBridge;
import com.atlassian.rm.common.bridges.jira.issue.link.IssueLinkServiceBridgeProxy;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.extensions.workitems.CreateIssueLinksResult;
import com.radiantminds.roadmap.common.extensions.workitems.IssueLinkRequest;
import com.radiantminds.roadmap.common.handlers.common.violations.ViolationMessage;
import com.radiantminds.roadmap.jira.common.components.extension.issues.links.IssueLinkUtils;
import com.radiantminds.roadmap.jira.common.components.extension.issues.links.exceptions.InvalidIssueLinkTypeException;
import java.util.HashSet;
import java.util.Iterator;

public class CreateIssueLinksRequestHandler {
    private static final Log LOGGER = Log.with(CreateIssueLinksRequestHandler.class);
    private final IssueLinkManager issueLinkManager;
    private final IssueLinkServiceBridgeProxy issueLinkServiceBridgeProxy;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueServiceBridgeProxy issueServiceBridgeProxy;
    private final JiraAuthenticationContext authenticationContext;
    private final FeatureExtension featureExtension;

    public CreateIssueLinksRequestHandler(IssueLinkManager issueLinkManager, IssueLinkServiceBridgeProxy issueLinkServiceBridgeProxy, IssueLinkTypeManager issueLinkTypeManager, JiraAuthenticationContext authenticationContext, IssueServiceBridgeProxy issueServiceBridgeProxy, FeatureExtension featureExtension) {
        this.issueLinkManager = issueLinkManager;
        this.issueLinkServiceBridgeProxy = issueLinkServiceBridgeProxy;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueServiceBridgeProxy = issueServiceBridgeProxy;
        this.authenticationContext = authenticationContext;
        this.featureExtension = featureExtension;
    }

    public CreateIssueLinksResult createIssueLinksForDependencies(IssueLinkRequest request) throws Exception {
        IssueLinkType issueLinkType;
        ApplicationUser applicationUser = this.authenticationContext.getUser();
        if (applicationUser == null) {
            LOGGER.warn("Failed to retrieve JIRA user.", new Object[0]);
            throw new Exception("Failed to retrieve JIRA user.");
        }
        IssueLinkServiceBridge issueLinkServiceBridge = (IssueLinkServiceBridge)this.issueLinkServiceBridgeProxy.get();
        IssueServiceBridge issueServiceBridge = (IssueServiceBridge)this.issueServiceBridgeProxy.get();
        CreateIssueLinksResult retVal = new CreateIssueLinksResult();
        if (request.getInwardIds().isEmpty() && request.getOutwardIds().isEmpty()) {
            return retVal;
        }
        if (!this.issueLinkManager.isLinkingEnabled()) {
            LOGGER.warn("Cannot create issue links, JIRA issue linking is disabled.", new Object[0]);
            retVal.addViolation(new ViolationMessage.Impl("error", "jira-issue-linking-disabled"));
            return retVal;
        }
        try {
            issueLinkType = IssueLinkUtils.getIssueLinkType(this.issueLinkTypeManager, request.getLinkTypeId());
        }
        catch (InvalidIssueLinkTypeException e) {
            LOGGER.warn("Cannot create issue links, issueLinkType with id '%s' was not found.", request.getLinkTypeId());
            retVal.addViolation(new ViolationMessage.Impl("error", "jira-issue-linking-invalid-type"));
            return retVal;
        }
        HashSet errorMessages = Sets.newHashSet();
        for (String issueKey : request.getIssueKeys()) {
            Direction direction;
            IssueService.IssueResult issueResult = issueServiceBridge.getIssue(applicationUser, issueKey);
            if (issueResult == null) {
                LOGGER.warn("Cannot create issue links, issueServiceBridge returned null for issueKey '%s'.", issueKey);
                retVal.addViolation(new ViolationMessage.Impl("warning", "jira-issue-linking-issue-not-found"));
                continue;
            }
            MutableIssue issue = issueResult.getIssue();
            if (issue == null) {
                LOGGER.warn("Cannot create issue links, issueServiceBridge returned null for issueKey '%s'.", issueKey);
                retVal.addViolation(new ViolationMessage.Impl("warning", "jira-issue-linking-issue-not-found"));
                continue;
            }
            if (request.getInwardIds().size() > 0) {
                direction = Direction.IN;
                if (this.featureExtension.isInvertedDependencyCreationEnabled()) {
                    direction = IssueLinkUtils.getInvertedIssueLinkDirection(direction);
                }
                errorMessages.addAll(IssueLinkUtils.createIssueLinks(issueLinkServiceBridge, applicationUser, issue, issueLinkType, direction, request.getInwardIds()));
            }
            if (request.getOutwardIds().size() <= 0) continue;
            direction = Direction.OUT;
            if (this.featureExtension.isInvertedDependencyCreationEnabled()) {
                direction = IssueLinkUtils.getInvertedIssueLinkDirection(direction);
            }
            errorMessages.addAll(IssueLinkUtils.createIssueLinks(issueLinkServiceBridge, applicationUser, issue, issueLinkType, direction, request.getOutwardIds()));
        }
        if (errorMessages.size() > 0) {
            Iterator errorMessagesIterator = errorMessages.iterator();
            while (errorMessagesIterator.hasNext()) {
                retVal.addViolation(new ViolationMessage.Impl("raw", (String)errorMessagesIterator.next()));
            }
        }
        return retVal;
    }
}

