/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.people.IResource;
import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingAssignment;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolution;
import com.radiantminds.roadmap.jira.common.components.extension.JiraUserManagementExtension;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class AssignmentUtils {
    private static final Log LOGGER = Log.with(AssignmentUtils.class);

    public static Set<String> getAssignedResources(Set<RestSchedulingAssignment> assignments) {
        HashSet retVal = Sets.newHashSet();
        if (assignments != null && assignments.iterator().hasNext()) {
            for (RestSchedulingAssignment assignment : assignments) {
                String resourceId = assignment.getResourceId();
                if (resourceId.startsWith("team-resource-")) continue;
                retVal.add(resourceId);
            }
        }
        return retVal;
    }

    public static String getExternalUserName(IWorkItem workItem, Set<String> assignedResources, PortfolioResourcePersistence resourcePersistence, JiraUserManagementExtension jiraUserManagementExtension) throws PersistenceException {
        LOGGER.info("Trying to get external user ID for %s.", workItem.getTitle());
        if (assignedResources != null && assignedResources.size() > 0) {
            LOGGER.info("Assigned resources (calculated): %s", assignedResources.toString());
        } else {
            LOGGER.info("No resources assigned (calculated).", new Object[0]);
        }
        if (workItem.getResources() != null && workItem.getResources().size() > 0) {
            LOGGER.info("Assigned resources (table): %s", workItem.getResources());
        } else {
            LOGGER.info("No resources assigned (table).", new Object[0]);
        }
        String resourceId = null;
        if (workItem.getResources() != null && workItem.getResources().size() == 1) {
            resourceId = workItem.getResources().iterator().next();
            LOGGER.info("Potential resource %s selected from table assignments.", resourceId);
        } else if (assignedResources != null && assignedResources.size() == 1) {
            resourceId = assignedResources.iterator().next();
            LOGGER.info("Check if assigned resource %s is part of table assignments %s.", resourceId, workItem.getResources());
            if (workItem.getResources() == null || workItem.getResources().size() <= 0 || workItem.getResources().contains(resourceId)) {
                LOGGER.info("Potential resource %s selected from calculated assignments.", resourceId);
            } else {
                LOGGER.info("Assigned calculated resource %s does not match table assignments.", resourceId);
                resourceId = null;
            }
        }
        if (resourceId != null) {
            Optional<String> externalPersonId = ((IResource)resourcePersistence.get(resourceId)).getPerson().getExternalId();
            if (externalPersonId.isPresent()) {
                Optional<String> jiraUserName = jiraUserManagementExtension.getUserName((String)externalPersonId.get());
                if (jiraUserName.isPresent()) {
                    LOGGER.info("Found JIRA user %s (ID=%s).", jiraUserName.get(), externalPersonId.get());
                    return (String)jiraUserName.get();
                }
                LOGGER.info("No JIRA username found for ID %s.", externalPersonId.get());
            } else {
                LOGGER.info("No matching JIRA user found.", new Object[0]);
            }
        } else {
            LOGGER.info("No resource was found.", new Object[0]);
        }
        return null;
    }

    public static Set<RestSchedulingAssignment> getFilteredAssignments(@Nullable RestSchedulingSolution solution, IWorkItem workItem, Optional<IStage> stage) {
        if (solution != null) {
            HashSet<String> workItemIds;
            Set filteredAssignments;
            HashSet assignments = Sets.newHashSet(solution.getAssignments());
            HashSet<String> skillIds = new HashSet<String>();
            if (stage.isPresent()) {
                skillIds.add("stageSkill-" + ((IStage)stage.get()).getId());
                for (ISkill skill : ((IStage)stage.get()).getSkills()) {
                    skillIds.add(skill.getId());
                }
            }
            return (filteredAssignments = Sets.filter((Set)assignments, (Predicate)new Predicate<RestSchedulingAssignment>(workItemIds = new HashSet<String>(AssignmentUtils.getAllChildIds(workItem)), skillIds){
                final /* synthetic */ Set val$workItemIds;
                final /* synthetic */ Set val$skillIds;
                {
                    this.val$workItemIds = set;
                    this.val$skillIds = set2;
                }

                public boolean apply(@Nullable RestSchedulingAssignment assignment) {
                    return assignment.isRelevantForWorkItem(this.val$workItemIds) && (this.val$skillIds.size() <= 0 || this.val$skillIds.contains(assignment.getSkillId()));
                }
            })).size() <= 0 ? null : filteredAssignments;
        }
        return null;
    }

    private static Set<String> getAllChildIds(IWorkItem workItem) {
        HashSet<String> ids = new HashSet<String>();
        if (workItem.getChildren().size() > 0) {
            for (IWorkItem iWorkItem : workItem.getChildren()) {
                ids.addAll(AssignmentUtils.getAllChildIds(iWorkItem));
            }
        }
        ids.add(workItem.getId());
        return ids;
    }

    public static boolean noResourceAssigned(IWorkItem workItem, Set<String> assignedResources) {
        boolean blackDataAssignmentsEmpty = workItem.getResources() == null || AssignmentUtils.resourcesAreEmpty(workItem.getResources());
        boolean greenDataAssignmentsEmpty = assignedResources == null || AssignmentUtils.resourcesAreEmpty(assignedResources);
        return blackDataAssignmentsEmpty && greenDataAssignmentsEmpty;
    }

    private static boolean resourcesAreEmpty(Set<String> resources) {
        return resources == null || resources.size() <= 0;
    }
}

