/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridge;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.issue.link.IssueLinkServiceBridge;
import com.atlassian.rm.common.bridges.jira.issue.link.IssueLinkServiceBridgeProxy;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.extensions.workitems.SyncRequest;
import com.radiantminds.roadmap.common.handlers.common.violations.ViolationMessage;
import com.radiantminds.roadmap.common.handlers.sync.workitems.WorkItemSyncConfiguration;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingAssignment;
import com.radiantminds.roadmap.common.utils.estimate.EstimateUtil;
import com.radiantminds.roadmap.jira.common.components.extension.JiraUserManagementExtension;
import com.radiantminds.roadmap.jira.common.components.extension.issues.links.IssueLinkUtils;
import com.radiantminds.roadmap.jira.common.components.extension.issues.links.exceptions.InvalidIssueLinkTypeException;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.AssignmentUtils;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.EstimateSyncUtils;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.FormattingUtils;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.LinkUtils;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.SyncConfigUtils;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.SyncIssueLinksRequest;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.SyncIssueLinksRequestHandler;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.SyncVersionUtils;
import com.radiantminds.roadmap.jira.common.components.sync.SynchronizationFlagHandler;
import com.radiantminds.roadmap.jira.common.components.utils.JiraErrorCollectionUtil;
import com.radiantminds.roadmap.jira.common.components.utils.JiraPropertyUtil;
import com.radiantminds.roadmap.jira.common.components.utils.JiraSyncUtil;
import com.radiantminds.roadmap.jira.common.components.utils.JiraTimeZoneUtil;
import com.radiantminds.roadmap.jira.common.components.utils.TimeTracking;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class IssueSyncronizationRequestHandler {
    private static final Log LOGGER = Log.with(IssueSyncronizationRequestHandler.class);
    private final SynchronizationFlagHandler flagHandler;
    private final CustomFields customFields;
    private final LocaleManager localeManager;
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueService issueService;
    private final IssueServiceBridgeProxy issueServiceBridgeProxy;
    private final VersionManager versionManager;
    private final PersistenceIndex persistenceIndex;
    private final PortfolioResourcePersistence resourcePersistence;
    private final PermissionManager permissionManager;
    private final IssueLinkManager issueLinkManager;
    private final IssueLinkService issueLinkService;
    private final IssueLinkServiceBridgeProxy issueLinkServiceBridgeProxy;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final FeatureExtension featureExtension;
    private final JiraSyncUtil jiraSyncUtil;
    private final SyncVersionUtils syncVersionUtils;
    private final JiraUserManagementExtension jiraUserManagementExtension;
    private static Ordering<RestSchedulingAssignment> ORDER_BY_ENDDATE = new Ordering<RestSchedulingAssignment>(){

        public int compare(@Nullable RestSchedulingAssignment assignment1, @Nullable RestSchedulingAssignment assignment2) {
            return new Long(assignment1.getEnd()).compareTo(assignment2.getEnd());
        }
    };

    public IssueSyncronizationRequestHandler(SynchronizationFlagHandler flagHandler, CustomFields customFields, LocaleManager localeManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, IssueService issueService, IssueServiceBridgeProxy issueServiceBridgeProxy, VersionManager versionManager, PermissionManager permissionManager, IssueLinkManager issueLinkManager, IssueLinkService issueLinkService, IssueLinkServiceBridgeProxy issueLinkServiceBridgeProxy, IssueLinkTypeManager issueLinkTypeManager, PersistenceIndex persistenceIndex, PortfolioResourcePersistence resourcePersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, JiraUserManagementExtension jiraUserManagementExtension, FeatureExtension featureExtension) {
        this.flagHandler = flagHandler;
        this.customFields = customFields;
        this.localeManager = localeManager;
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.issueService = issueService;
        this.issueServiceBridgeProxy = issueServiceBridgeProxy;
        this.permissionManager = permissionManager;
        this.versionManager = versionManager;
        this.persistenceIndex = persistenceIndex;
        this.resourcePersistence = resourcePersistence;
        this.issueLinkManager = issueLinkManager;
        this.issueLinkService = issueLinkService;
        this.issueLinkServiceBridgeProxy = issueLinkServiceBridgeProxy;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.jiraSyncUtil = new JiraSyncUtil(extensionLinkPersistence);
        this.syncVersionUtils = new SyncVersionUtils(this.jiraSyncUtil);
        this.jiraUserManagementExtension = jiraUserManagementExtension;
        this.featureExtension = featureExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ViolationMessage> syncToExtention(SyncRequest request) throws Exception {
        ApplicationUser applicationUser = this.authenticationContext.getUser();
        if (applicationUser == null) {
            LOGGER.warn("Failed to retrieve JIRA user.", new Object[0]);
            throw new Exception("Failed to retrieve JIRA user.");
        }
        LOGGER.info("Start syncing linked issues to JIRA...", new Object[0]);
        IssueServiceBridge issueServiceBridge = (IssueServiceBridge)this.issueServiceBridgeProxy.get();
        IssueLinkServiceBridge issueLinkServiceBridge = (IssueLinkServiceBridge)this.issueLinkServiceBridgeProxy.get();
        ArrayList retVal = Lists.newArrayList();
        boolean timetrackingEnabled = TimeTracking.isEnabled(this.applicationProperties);
        boolean timetrackingIsLegacyMode = TimeTracking.isLegacyMode(this.applicationProperties);
        TimeZone jiraTimeZone = JiraTimeZoneUtil.getJiraDefaultTimeZone(this.applicationProperties);
        Locale locale = this.localeManager.getLocaleFor(applicationUser);
        SimpleDateFormat dateFormat = FormattingUtils.getDateFormat(this.applicationProperties, locale);
        WorkItemSyncConfiguration config = request.getConfig();
        IWorkItem workItem = request.getWorkItem();
        LOGGER.info("JIRA_DATE_PICKER_JAVA_FORMAT=%s, localized=%s", dateFormat.toPattern(), dateFormat.toLocalizedPattern());
        LOGGER.info("JIRA_LF_DATE_DMY=%s", new SimpleDateFormat(JiraPropertyUtil.getValueOrDefault(this.applicationProperties, "jira.lf.date.dmy")).toPattern());
        LOGGER.info("JIRA default timezone=%s", jiraTimeZone.toString());
        Set<Object> storyPointsEnabledIssueTypeIds = Sets.newHashSet();
        CustomField storyPointsField = null;
        if (PlanningUnit.STORY_POINTS.unit().equals(request.getPlanningUnit())) {
            storyPointsField = this.customFields.tryGetStoryPointsCustomField();
            if (storyPointsField == null) {
                retVal.add(new ViolationMessage.Impl("warning", "sync-story-points-field-missing"));
                LOGGER.warn("Cannot update story points, custom field is unavailable.", new Object[0]);
                if (SyncConfigUtils.syncOnlyEstimates(config)) {
                    return retVal;
                }
            } else if (config != null && config.isEstimateSynced() && !storyPointsField.isGlobal()) {
                storyPointsEnabledIssueTypeIds = this.customFields.getAssociatedIssueTypeIds(storyPointsField);
            }
        } else {
            if (!timetrackingEnabled) {
                LOGGER.warn("Cannot update estimates to JIRA; time tracking is disabled.", new Object[0]);
                retVal.add(new ViolationMessage.Impl("warning", "sync-time-tracking-disabled"));
                if (SyncConfigUtils.syncOnlyEstimates(config)) {
                    return retVal;
                }
            }
            if (timetrackingIsLegacyMode) {
                LOGGER.info("JIRA time tracking is set to legacy mode.", new Object[0]);
            }
        }
        boolean canIssueLinksBeSynced = false;
        if (config.areIssueLinksSynced()) {
            try {
                IssueLinkUtils.getIssueLinkType(this.issueLinkTypeManager, config.getIssueLinkTypeId());
                canIssueLinksBeSynced = this.issueLinkManager.isLinkingEnabled();
                if (!canIssueLinksBeSynced) {
                    retVal.add(new ViolationMessage.Impl("error", "jira-issue-linking-disabled"));
                }
            }
            catch (InvalidIssueLinkTypeException e) {
                retVal.add(new ViolationMessage.Impl("error", "jira-issue-linking-invalid-type"));
            }
            if (!canIssueLinksBeSynced && SyncConfigUtils.syncOnlyIssueLinks(config)) {
                return retVal;
            }
        }
        Set<RestSchedulingAssignment> filteredAssignments = AssignmentUtils.getFilteredAssignments(request.getSolution(), workItem, (Optional<IStage>)Optional.absent());
        Set<String> assignedResources = AssignmentUtils.getAssignedResources(filteredAssignments);
        List<IExtensionLink> links = this.jiraSyncUtil.getIssueLinks(workItem.getId());
        if (links.size() <= 0) {
            LOGGER.warn("There are no issues linked to %s; cannot update issue.", workItem.getTitle());
            retVal.add(new ViolationMessage.Impl("warning", "sync-issue-not-found"));
            return retVal;
        }
        for (IExtensionLink link : links) {
            IssueService.IssueResult issueResult;
            MutableIssue issue;
            LOGGER.info("Syncing issue %s of work item %s...", link.getExtensionLink(), workItem.getTitle());
            Optional<IStage> stage = Optional.absent();
            if (link.getExtensionKey().startsWith("jira-issue-stage-")) {
                stage = LinkUtils.getStageFromLink(link, request.getStages());
                if (stage == null) {
                    ViolationMessage.Impl msg = new ViolationMessage.Impl("raw", "sync-stage-not-found", link.getExtensionLink());
                    retVal.add(msg);
                    LOGGER.warn("Stage for issue %s of work item %s not found.", link.getExtensionLink(), workItem.getTitle());
                    continue;
                }
                filteredAssignments = AssignmentUtils.getFilteredAssignments(request.getSolution(), workItem, stage);
                assignedResources = AssignmentUtils.getAssignedResources(filteredAssignments);
            }
            if ((issue = (issueResult = issueServiceBridge.getIssue(applicationUser, link.getExtensionLink())).getIssue()) == null || !issueResult.isValid()) {
                LOGGER.warn("Issue %s linked to work item %s not found.", link.getExtensionLink(), workItem.getTitle());
                if (issueResult.getErrorCollection().hasAnyErrors()) {
                    retVal.addAll(JiraErrorCollectionUtil.handleValidationErrors(issueResult.getErrorCollection()));
                    continue;
                }
                retVal.add(new ViolationMessage.Impl("warning", "sync-issue-not-found"));
                continue;
            }
            Long issueId = issue.getId();
            IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters();
            issueInputParameters.setSkipScreenCheck(true);
            issueInputParameters.setRetainExistingValuesWhenParameterNotProvided(true, true);
            if (config.isVersionSynced()) {
                if (this.permissionManager.hasPermission(14, (Issue)issue, applicationUser)) {
                    Set<String> releaseIds = SyncVersionUtils.getTransitiveReleaseIds(workItem, request.getSolution());
                    if (!releaseIds.isEmpty()) {
                        Set<Long> fixVersionIds = this.syncVersionUtils.getFixVersionIdsInIssueProject(this.versionManager, issue.getProjectObject().getId(), releaseIds, retVal);
                        if (config.syncVersionsDestructively()) {
                            issueInputParameters.setFixVersionIds(fixVersionIds.toArray(new Long[fixVersionIds.size()]));
                            if (fixVersionIds.isEmpty()) {
                                LOGGER.warn("There are no version links to the issue's project for the releases set on this work item.", new Object[0]);
                                retVal.add(new ViolationMessage.Impl("warning", "sync-no-versions-linked-to-issue-project", link.getExtensionLink()));
                            }
                        } else if (!fixVersionIds.isEmpty()) {
                            Set<Long> alreadySetFixVersions = SyncVersionUtils.getSetFixVersionsForIssue(issue);
                            alreadySetFixVersions.addAll(fixVersionIds);
                            issueInputParameters.setFixVersionIds(alreadySetFixVersions.toArray(new Long[alreadySetFixVersions.size()]));
                        } else {
                            LOGGER.warn("There are no version links to the issue's project for the releases set on this work item.", new Object[0]);
                            retVal.add(new ViolationMessage.Impl("warning", "sync-no-versions-linked-to-issue-project", link.getExtensionLink()));
                        }
                    } else {
                        retVal.add(new ViolationMessage.Impl("warning", "sync-no-release-for-item"));
                    }
                } else {
                    LOGGER.warn("User has no permission to resolve issues and can thus not update the fix version.", new Object[0]);
                    retVal.add(new ViolationMessage.Impl("warning", "sync-no-set-version-permission"));
                }
            }
            if (config.isEstimateSynced()) {
                EstimateUtil estimateUtil = new EstimateUtil(this.persistenceIndex.getBeanFromContext(PortfolioEstimatePersistence.class));
                if (PlanningUnit.STORY_POINTS.unit().equals(request.getPlanningUnit())) {
                    if (storyPointsField != null) {
                        if (storyPointsField.isGlobal() || storyPointsEnabledIssueTypeIds.contains(issue.getIssueTypeObject().getId())) {
                            IssueSyncronizationRequestHandler.writeStoryPointsToIssueInputParameters(estimateUtil.computeEstimates(workItem, stage, request.getStages(), request.getStagePercentages(), true), issueInputParameters, storyPointsField.getIdAsLong(), locale);
                        } else {
                            LOGGER.warn("Estimates cannot be updated; story points are not enabled for this issue type.", new Object[0]);
                            retVal.add(new ViolationMessage.Impl("warning", "sync-story-points-not-enabled"));
                        }
                    }
                } else if (timetrackingEnabled) {
                    IssueSyncronizationRequestHandler.writeEstimatesToIssueInputParameters(estimateUtil.computeEstimates(workItem, stage, request.getStages(), request.getStagePercentages(), true), issueInputParameters, request.getPlanningUnit(), request.getHoursPerDay(), timetrackingIsLegacyMode);
                }
            }
            if (config.isDueDateSynced()) {
                LOGGER.info("Trying to sync due date...", new Object[0]);
                if (filteredAssignments != null) {
                    DateTime updatedDueDate = new DateTime(((RestSchedulingAssignment)ORDER_BY_ENDDATE.max(filteredAssignments)).getEnd());
                    LOGGER.info("Raw due date (no timezone conversion)=%s", updatedDueDate.toString());
                    Date timeZonedDueDate = JiraTimeZoneUtil.removeTimeZoneOffset(updatedDueDate.toDate(), jiraTimeZone);
                    LOGGER.info("Setting due date to %s...", dateFormat.format(timeZonedDueDate));
                    issueInputParameters.setDueDate(dateFormat.format(timeZonedDueDate));
                } else if (request.getSolution() != null) {
                    retVal.add(new ViolationMessage.Impl("warning", "sync-estimates-item-not-scheduled"));
                    LOGGER.warn("Work item %s not scheduled; due date could not be updated.", workItem.getTitle());
                } else {
                    LOGGER.warn("No assignments found for work item %s and no solution is present; due date could not be updated.", workItem.getTitle());
                }
            }
            if (config.isAssigneeSynced()) {
                if (AssignmentUtils.noResourceAssigned(workItem, assignedResources)) {
                    retVal.add(new ViolationMessage.Impl("warning", "sync-estimates-no-users-assigned"));
                    LOGGER.warn("User for item %s was not synced; there are no users assigned to this issue.", workItem.getTitle());
                } else {
                    String externalUserId = AssignmentUtils.getExternalUserName(workItem, assignedResources, this.resourcePersistence, this.jiraUserManagementExtension);
                    if (externalUserId != null) {
                        issueInputParameters.setAssigneeId(externalUserId);
                    } else {
                        retVal.add(new ViolationMessage.Impl("warning", "sync-estimates-user-not-synced"));
                        LOGGER.warn("User for item %s was not synced; there are either more than one assignees or the assignee is no JIRA user.", workItem.getTitle());
                    }
                }
            }
            if (config.isSummarySynced()) {
                String title = JiraSyncUtil.getIssueTitleForLink(workItem, link, this.persistenceIndex.getBeanFromContext(PortfolioStagePersistence.class));
                issueInputParameters.setSummary(title);
                CustomField epicTitleField = this.customFields.tryGetEpicLabelField();
                if (epicTitleField != null) {
                    issueInputParameters.addCustomFieldValue(epicTitleField.getIdAsLong(), new String[]{title});
                }
            }
            if (config.isDescriptionSynced()) {
                issueInputParameters.setDescription(workItem.getDetails());
            }
            if (config.areIssueLinksSynced() && canIssueLinksBeSynced) {
                SyncIssueLinksRequest syncIssueLinksRequest = new SyncIssueLinksRequest(issue, applicationUser, config.getIssueLinkTypeId(), request.getInwardDependencyIssueKeys(), request.getOutwardDependencyIssueKeys(), config.syncIssueLinksDesctructively());
                SyncIssueLinksRequestHandler issueLinkHandler = new SyncIssueLinksRequestHandler(this.issueLinkManager, this.issueLinkService, issueLinkServiceBridge, this.issueLinkTypeManager, issueServiceBridge, this.permissionManager, this.featureExtension);
                List<ViolationMessage> issueLinkViolations = issueLinkHandler.syncIssueLinks(syncIssueLinksRequest);
                retVal.addAll(issueLinkViolations);
            }
            try {
                this.flagHandler.startJiraUpdate();
                IssueService.UpdateValidationResult validationResult = issueServiceBridge.validateUpdate(applicationUser, issueId, issueInputParameters);
                if (validationResult.isValid()) {
                    IssueService.IssueResult updateResult = issueServiceBridge.update(applicationUser, validationResult);
                    if (updateResult.isValid()) continue;
                    LOGGER.warn("Failed update issue %s of work item %s.", link.getExtensionLink(), workItem.getTitle());
                    retVal.addAll(JiraErrorCollectionUtil.handleValidationErrors(validationResult.getErrorCollection()));
                    continue;
                }
                LOGGER.warn("Failed update issue %s of work item %s.", link.getExtensionLink(), workItem.getTitle());
                retVal.addAll(JiraErrorCollectionUtil.handleValidationErrors(validationResult.getErrorCollection()));
            }
            finally {
                this.flagHandler.endJiraUpdate();
            }
        }
        if (retVal.size() <= 0) {
            LOGGER.info("Successfully synced linked issues to JIRA.", new Object[0]);
        } else {
            LOGGER.warn("Finished sync to JIRA with errors and/or warnings.", new Object[0]);
        }
        return retVal.size() > 0 ? retVal : null;
    }

    private static void writeStoryPointsToIssueInputParameters(Map<EstimateUtil.EstimateType, Double> updatedEstimates, IssueInputParameters issueInputParameters, Long storyPointsFieldId, Locale locale) {
        boolean hasCurrent = updatedEstimates.containsKey((Object)EstimateUtil.EstimateType.CURRENT);
        boolean hasOriginal = updatedEstimates.containsKey((Object)EstimateUtil.EstimateType.ORIGINAL);
        Double storyPoints = null;
        if (hasCurrent && hasOriginal) {
            storyPoints = updatedEstimates.get((Object)EstimateUtil.EstimateType.CURRENT);
        } else if (hasCurrent) {
            storyPoints = updatedEstimates.get((Object)EstimateUtil.EstimateType.CURRENT);
        } else if (hasOriginal) {
            storyPoints = updatedEstimates.get((Object)EstimateUtil.EstimateType.ORIGINAL);
        }
        if (storyPoints != null) {
            String formattedStoryPoints = storyPoints == 0.0 && !hasOriginal ? "" : FormattingUtils.formatStoryPoints(locale, storyPoints);
            LOGGER.info("Setting story points to '%s'.", storyPoints);
            issueInputParameters.addCustomFieldValue(storyPointsFieldId, new String[]{formattedStoryPoints});
        } else {
            LOGGER.warn("No estimates set on this issue, story points are not updated.", new Object[0]);
        }
    }

    private static void writeEstimatesToIssueInputParameters(Map<EstimateUtil.EstimateType, Double> updatedEstimates, IssueInputParameters issueInputParameters, String planningUnit, Double hoursPerDay, boolean timetrackingIsLegacyMode) {
        boolean hasOriginal = updatedEstimates.containsKey((Object)EstimateUtil.EstimateType.ORIGINAL);
        Double current = updatedEstimates.get((Object)EstimateUtil.EstimateType.CURRENT);
        if (current == null) {
            current = 0.0;
        }
        Optional original = hasOriginal ? Optional.of((Object)updatedEstimates.get((Object)EstimateUtil.EstimateType.ORIGINAL)) : Optional.of((Object)current);
        EstimateSyncUtils.setEstimatesOnJiraIssue(issueInputParameters, (Optional<Double>)Optional.of((Object)current), (Optional<Double>)original, planningUnit, hoursPerDay, timetrackingIsLegacyMode);
    }
}

