/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.release;

import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.jira.project.version.VersionBuilderBridge;
import com.atlassian.rm.common.bridges.jira.project.version.VersionServiceBridge;
import com.atlassian.rm.common.bridges.jira.project.version.VersionServiceBridgeProxy;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtension;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionDataRequest;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseSyncResult;
import com.radiantminds.roadmap.common.extensions.releases.ReleasesExtensionData;
import com.radiantminds.roadmap.common.extensions.releases.VersionsBulkSyncRequest;
import com.radiantminds.roadmap.common.handlers.common.violations.ViolationMessage;
import com.radiantminds.roadmap.jira.common.components.extension.release.JiraReleaseExtensionLinkData;
import com.radiantminds.roadmap.jira.common.components.extension.release.JiraReleaseSyncResult;
import com.radiantminds.roadmap.jira.common.components.extension.release.JiraReleasesExtensionData;
import com.radiantminds.roadmap.jira.common.components.utils.JiraErrorCollectionUtil;
import com.radiantminds.roadmap.jira.common.components.utils.JiraTimeZoneUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraReleaseExtension
implements ReleaseExtension {
    private static final Log LOGGER = Log.with(JiraReleaseExtension.class);
    public static final String NO_ADMINISTRATE_PROEJCT_PERMISSION = "sync-version-no-permission";
    public static final String INVALID_RELEASE_LINK = "sync-invalid-release-link";
    private final VersionServiceBridgeProxy versionServiceBridgeProxy;
    private final VersionManager versionManager;
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final AvatarService avatarService;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectManager projectManager;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public JiraReleaseExtension(VersionServiceBridgeProxy versionServiceBridgeProxy, VersionManager versionManager, PermissionManager permissionManager, GlobalPermissionManager globalPermissionManager, AvatarService avatarService, JiraAuthenticationContext authenticationContext, ProjectManager projectManager, ApplicationProperties applicationProperties) {
        this.versionServiceBridgeProxy = versionServiceBridgeProxy;
        this.versionManager = versionManager;
        this.permissionManager = permissionManager;
        this.globalPermissionManager = globalPermissionManager;
        this.avatarService = avatarService;
        this.authenticationContext = authenticationContext;
        this.projectManager = projectManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public ReleasesExtensionData getReleasesExtensionData(ReleaseExtensionDataRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request must not be null");
        LOGGER.debug("received request: %s", request);
        VersionServiceBridge versionServiceBridge = (VersionServiceBridge)this.versionServiceBridgeProxy.get();
        ApplicationUser applicationUser = this.getApplicationUser();
        HashMap data = Maps.newHashMap();
        for (String link : request.getExtensionLinks()) {
            Long id = this.parseLink(link);
            if (id == null) {
                LOGGER.info("could not parse version ID for link: %s", link);
                continue;
            }
            VersionService.VersionResult result = versionServiceBridge.getVersionById(applicationUser, id);
            if (result.getErrorCollection().hasAnyErrors()) {
                LOGGER.warn("Could not find/access JIRA version with ID: %s\"", Joiner.on((String)";").join((Iterable)result.getErrorCollection().getErrorMessages()));
                continue;
            }
            if (result.getVersion() == null) {
                LOGGER.info("could not find JIRA version with ID: %s", id);
                continue;
            }
            Long projectId = result.getVersion().getProjectId();
            Project project = this.projectManager.getProjectObj(projectId);
            if (project == null) {
                LOGGER.info("no project found for ID: %s", projectId);
                continue;
            }
            if (!(this.permissionManager.hasPermission(10, project, applicationUser) || this.permissionManager.hasPermission(23, project, applicationUser) || this.globalPermissionManager.hasPermission(0, applicationUser))) {
                LOGGER.info("no permission for project with ID: %s", projectId);
                continue;
            }
            JiraReleaseExtensionLinkData linkData = JiraReleaseExtensionLinkData.createInstance(id.toString(), result.getVersion(), project, this.avatarService);
            data.put(id.toString(), linkData);
        }
        JiraReleasesExtensionData releaseExtensionData = new JiraReleasesExtensionData(data);
        LOGGER.debug("created release extension data: %s", releaseExtensionData);
        return releaseExtensionData;
    }

    @Override
    @Nonnull
    public ReleaseSyncResult synchronizeReleaseData(@Nonnull VersionsBulkSyncRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request must not be null");
        ApplicationUser applicationUser = this.getApplicationUser();
        ArrayList violationMessages = Lists.newArrayList();
        Set<String> extensionLinks = request.getExtensionLinks();
        for (String link : extensionLinks) {
            VersionService.VersionBuilderValidationResult updateValidationResult;
            Long id = this.parseLink(link);
            if (id == null) {
                LOGGER.info("could not parse version ID for link: %s", link);
                violationMessages.add(new ViolationMessage.Impl("warning", INVALID_RELEASE_LINK));
                continue;
            }
            Version jiraVersion = this.versionManager.getVersion(id);
            if (jiraVersion == null) continue;
            if (!this.permissionManager.hasPermission(23, jiraVersion.getProjectObject(), applicationUser) && !this.globalPermissionManager.hasPermission(0, applicationUser)) {
                if (!this.permissionManager.hasPermission(10, jiraVersion.getProjectObject(), applicationUser)) continue;
                String projectDescription = "unknown project";
                Project projectForVersion = jiraVersion.getProjectObject();
                if (projectForVersion != null) {
                    projectDescription = projectForVersion.getName() + " (" + projectForVersion.getKey() + ")";
                }
                violationMessages.add(new ViolationMessage.Impl("warning", NO_ADMINISTRATE_PROEJCT_PERMISSION, projectDescription));
                continue;
            }
            VersionServiceBridge versionServiceBridge = (VersionServiceBridge)this.versionServiceBridgeProxy.get();
            VersionBuilderBridge versionBuilder = versionServiceBridge.newVersionBuilder(jiraVersion);
            if (request.isSyncName()) {
                versionBuilder.name(request.getName());
            }
            if (request.isSyncStartDate()) {
                versionBuilder.startDate(this.getTimeZonedDate(request.getStartDate()));
            }
            if (request.isSyncReleaseDate()) {
                versionBuilder.releaseDate(this.getTimeZonedDate(request.getReleaseDate()));
            }
            if ((updateValidationResult = versionServiceBridge.validateUpdate(applicationUser, versionBuilder)).isValid()) {
                versionServiceBridge.update(applicationUser, updateValidationResult);
                continue;
            }
            ErrorCollection errors = updateValidationResult.getErrorCollection();
            List<ViolationMessage> messages = JiraErrorCollectionUtil.handleValidationErrors(errors);
            violationMessages.addAll(messages);
        }
        JiraReleaseSyncResult result = new JiraReleaseSyncResult(violationMessages);
        return result;
    }

    @Override
    public String getReleaseName(@Nonnull Long releaseId) throws Exception {
        VersionService.VersionResult versionResult = ((VersionServiceBridge)this.versionServiceBridgeProxy.get()).getVersionById(this.getApplicationUser(), releaseId);
        if (versionResult.isValid()) {
            return versionResult.getVersion().getProjectObject().getKey() + " (" + versionResult.getVersion().getName() + ")";
        }
        if (versionResult.getErrorCollection() != null) {
            JiraErrorCollectionUtil.handleValidationErrors(versionResult.getErrorCollection());
        }
        return null;
    }

    private ApplicationUser getApplicationUser() throws Exception {
        ApplicationUser applicationUser = this.authenticationContext.getUser();
        if (applicationUser == null) {
            LOGGER.warn("Failed to retrieve JIRA user.", new Object[0]);
            throw new Exception("Failed to retrieve JIRA user.");
        }
        return applicationUser;
    }

    protected Date getTimeZonedDate(@Nullable Long timeStamp) {
        if (timeStamp == null) {
            return null;
        }
        TimeZone jiraTimeZone = JiraTimeZoneUtil.getJiraDefaultTimeZone(this.applicationProperties);
        return JiraTimeZoneUtil.removeTimeZoneOffset(new Date(timeStamp), jiraTimeZone);
    }

    private Long parseLink(String link) {
        try {
            return Long.valueOf(link);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

