/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.issues.sync.tasks;

import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.extensions.workitems.IIssueData;
import com.radiantminds.roadmap.common.extensions.workitems.IIssueRequest;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestEstimate;
import com.radiantminds.roadmap.jira.common.components.issues.sync.tasks.BaseEstimationSyncTask;
import java.util.List;
import java.util.Map;

public class StoryPointsSyncTask
extends BaseEstimationSyncTask {
    private static final Log LOGGER = Log.with(StoryPointsSyncTask.class);
    private final PortfolioEstimatePersistence estimatePersistence;
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final Double storyPoints;
    private final Optional<Integer> stageId;
    private final List<IExtensionLink> stageLinks;

    public StoryPointsSyncTask(PortfolioEstimatePersistence estimatePersistence, PortfolioWorkItemPersistence workItemPersistence, WorkItemExtension workItemExtension, Double storyPoints, Optional<Integer> stageId, List<IExtensionLink> stageLinks) {
        super(estimatePersistence, workItemExtension, stageId, IIssueRequest.EstimationMethod.STORY_POINTS);
        this.estimatePersistence = estimatePersistence;
        this.workItemPersistence = workItemPersistence;
        this.storyPoints = storyPoints;
        this.stageId = stageId;
        this.stageLinks = stageLinks;
    }

    @Override
    public boolean apply(MutableIssue issue, IssueInputParameters issueInputParameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean apply(IWorkItem workItem) {
        try {
            if (workItem.isInitiative()) {
                return false;
            }
            if (this.workItemPersistence.countChildren(workItem.getId()) > 0) {
                return false;
            }
            if (this.stageId.isPresent()) {
                Optional<IEstimate> stageEstimate = this.getCurrentStageEstimate(workItem.getId(), DataMode.Default);
                if (stageEstimate.isPresent() && Objects.equal((Object)((IEstimate)stageEstimate.get()).getEstimate(), (Object)this.storyPoints)) {
                    return false;
                }
                if (this.hasTotalEstimate(workItem.getId(), DataMode.Default)) {
                    Map<String, IIssueData> stageData = this.getStageDataFromJira(this.stageLinks);
                    for (String stageId : stageData.keySet()) {
                        Double estimate = stageData.get(stageId).getStoryPoints();
                        this.estimatePersistence.setStageEstimate(workItem.getId(), stageId, new RestEstimate(estimate), DataMode.Default);
                    }
                }
                this.estimatePersistence.setStageEstimate(workItem.getId(), String.valueOf(this.stageId.get()), new RestEstimate(this.storyPoints), DataMode.Default);
                return true;
            }
            Optional<IEstimate> currentEstimate = this.estimatePersistence.getTotalEstimate(workItem.getId(), DataMode.Default);
            if (currentEstimate.isPresent() && Objects.equal((Object)((IEstimate)currentEstimate.get()).getEstimate(), (Object)this.storyPoints)) {
                return false;
            }
            this.estimatePersistence.setTotalEstimate(workItem.getId(), new RestEstimate(this.storyPoints), DataMode.Default);
            return true;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to sync time-based estimates for work item %s.", workItem.getId());
            LOGGER.exception(ex);
            return false;
        }
    }
}

