/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.utils.customfields;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldServiceBridge;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFields;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldsServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.issue.fields.CustomFieldHelperBridge;
import com.atlassian.rm.common.bridges.jira.issue.fields.CustomFieldHelperBridgeProxy;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFieldsService;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.JiraAgileCustomFieldData;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomFields
implements CustomFieldsService {
    private static final Log LOGGER = Log.with(CustomFields.class);
    private final CustomFieldHelperBridgeProxy customFieldHelperBridgeProxy;
    private final JiraAgileAccessor agileAccessor;
    private final AgileCustomFieldsServiceBridgeProxy agileCustomFieldServiceBridgeProxy;

    @Autowired
    public CustomFields(CustomFieldHelperBridgeProxy customFieldHelperBridgeProxy, JiraAgileAccessor agileAccessor, AgileCustomFieldsServiceBridgeProxy agileCustomFieldServiceBridgeProxy) {
        this.customFieldHelperBridgeProxy = customFieldHelperBridgeProxy;
        this.agileAccessor = agileAccessor;
        this.agileCustomFieldServiceBridgeProxy = agileCustomFieldServiceBridgeProxy;
    }

    @Override
    public CustomField getStoryPointsCustomField() throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        return this.getCustomField(new Function<AgileCustomFields, CustomField>(){

            public CustomField apply(AgileCustomFields customFields) {
                return customFields.getStoryPointsField();
            }
        });
    }

    @Override
    public CustomField getEpicLabelCustomField() throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        return this.getCustomField(new Function<AgileCustomFields, CustomField>(){

            public CustomField apply(AgileCustomFields customFields) {
                return customFields.getEpicLabelField();
            }
        });
    }

    @Override
    public CustomField getEpicLinkCustomField() throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        return this.getCustomField(new Function<AgileCustomFields, CustomField>(){

            public CustomField apply(AgileCustomFields customFields) {
                return customFields.getEpicLinkField();
            }
        });
    }

    @Override
    public CustomField tryGetStoryPointsCustomField() {
        return this.tryGetAgileValue(new AgileFunction<CustomField>(){

            @Override
            public CustomField get() throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
                return CustomFields.this.getStoryPointsCustomField();
            }
        });
    }

    @Override
    public CustomField tryGetEpicLabelField() {
        return this.tryGetAgileValue(new AgileFunction<CustomField>(){

            @Override
            public CustomField get() throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
                return CustomFields.this.getEpicLabelCustomField();
            }
        });
    }

    @Override
    public CustomField tryGetEpicLinkField() {
        return this.tryGetAgileValue(new AgileFunction<CustomField>(){

            @Override
            public CustomField get() throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
                return CustomFields.this.getEpicLinkCustomField();
            }
        });
    }

    @Override
    public JiraAgileCustomFieldData getJiraAgileData() throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        AgileCustomFieldServiceBridge agileCustomFieldServiceBridge = (AgileCustomFieldServiceBridge)this.agileCustomFieldServiceBridgeProxy.get();
        AgileCustomFields customFields = agileCustomFieldServiceBridge.getCustomFields();
        CustomField epicNameCustomField = customFields.getEpicLabelField();
        CustomField epicLinkCustomField = customFields.getEpicLinkField();
        CustomField storyPointsCustomField = customFields.getStoryPointsField();
        String epicIssueTypeId = this.getEpicIssueTypeId(epicNameCustomField);
        Set<String> storyPointEnabledIssueTypeIds = this.getAssociatedIssueTypeIds(storyPointsCustomField);
        return new JiraAgileCustomFieldData(epicNameCustomField, epicLinkCustomField, storyPointsCustomField, epicIssueTypeId, storyPointEnabledIssueTypeIds);
    }

    @Override
    public Optional<JiraAgileCustomFieldData> tryGetJiraAgileData() {
        return Optional.fromNullable((Object)this.tryGetAgileValue(new AgileFunction<JiraAgileCustomFieldData>(){

            @Override
            public JiraAgileCustomFieldData get() throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
                return CustomFields.this.getJiraAgileData();
            }
        }));
    }

    public Set<String> getAssociatedIssueTypeIds(CustomField customField) {
        List<IssueType> associatedIssueTypes = ((CustomFieldHelperBridge)this.customFieldHelperBridgeProxy.get()).getAssociatedIssueTypes(customField);
        if (associatedIssueTypes != null) {
            HashSet retVal = Sets.newHashSet();
            for (IssueType associatedIssueType : associatedIssueTypes) {
                if (associatedIssueType == null) continue;
                retVal.add(associatedIssueType.getId());
            }
            return retVal;
        }
        return Sets.newHashSet();
    }

    private CustomField getCustomField(Function<AgileCustomFields, CustomField> getCustomField) throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        AgileCustomFieldServiceBridge bridge = (AgileCustomFieldServiceBridge)this.agileCustomFieldServiceBridgeProxy.get();
        AgileCustomFields customFields = bridge.getCustomFields();
        return (CustomField)getCustomField.apply((Object)customFields);
    }

    private String getEpicIssueTypeId(CustomField epicLabelCustomField) throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        Set<String> epicLabelIssueTypes = this.getAssociatedIssueTypeIds(epicLabelCustomField);
        if (epicLabelIssueTypes.size() == 1) {
            return epicLabelIssueTypes.iterator().next();
        }
        LOGGER.warn("Unexpected number of epic label issue types: " + epicLabelIssueTypes.size(), new Object[0]);
        return null;
    }

    private <T> T tryGetAgileValue(AgileFunction<T> func) {
        if (this.agileAccessor.isUsable()) {
            try {
                return func.get();
            }
            catch (AgileNotAvailableException agileNotAvailableException) {
            }
            catch (AgileCustomFieldNotAvailableException agileCustomFieldNotAvailableException) {
                // empty catch block
            }
        }
        return null;
    }

    private static interface AgileFunction<T> {
        public T get() throws AgileNotAvailableException, AgileCustomFieldNotAvailableException;
    }
}

