CREATE OR REPLACE FUNCTION create_ao_schema()
  RETURNS INTEGER AS $$
BEGIN

  BEGIN
    CREATE TABLE "AO_A415DF_AOABILITY" (
      "ABILITY_VALUE" DOUBLE PRECISION,
      "AOPERSON_ID"   INTEGER,
      "ID_OTHER"      SERIAL NOT NULL,
      "TARGET_ID"     INTEGER,
      "TARGET_TYPE"   CHARACTER VARYING(255),
      "VERSION"       BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOABSENCE" (
      "AOPERSON_ID"            INTEGER,
      "DESCRIPTION"            CHARACTER VARYING(255),
      "DETAILS"                TEXT,
      "END_DATE"               BIGINT,
      "ID_OTHER"               SERIAL NOT NULL,
      "ORDER_RANGE_IDENTIFIER" CHARACTER VARYING(255),
      "SORT_ORDER"             BIGINT,
      "START_DATE"             BIGINT,
      "TITLE"                  CHARACTER VARYING(255),
      "VERSION"                BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOAVAILABILITY" (
      "AORESOURCE_ID"          INTEGER,
      "AVAILABILITY"           DOUBLE PRECISION,
      "DESCRIPTION"            CHARACTER VARYING(255),
      "DETAILS"                TEXT,
      "END_DATE"               BIGINT,
      "ID_OTHER"               SERIAL NOT NULL,
      "ORDER_RANGE_IDENTIFIER" CHARACTER VARYING(255),
      "SORT_ORDER"             BIGINT,
      "START_DATE"             BIGINT,
      "TITLE"                  CHARACTER VARYING(255),
      "VERSION"                BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOCONFIGURATION" (
      "ID_OTHER"    SERIAL NOT NULL,
      "INITIALIZED" BOOLEAN,
      "INIT_STATE"  INTEGER
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOCUSTOM_WORDING" (
      "ID_OTHER"   SERIAL NOT NULL,
      "WORD_KEY"   CHARACTER VARYING(255),
      "WORD_VALUE" CHARACTER VARYING(255)
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AODEPENDENCY" (
      "DEPENDEE"  INTEGER,
      "DEPENDENT" INTEGER,
      "ID_OTHER"  SERIAL NOT NULL
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AODOOR_STOP" (
      "ID" SERIAL NOT NULL
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOESTIMATE" (
      "AOWORK_ITEM_ID" INTEGER,
      "CURRENCY"       INTEGER,
      "ESTIMATE"       DOUBLE PRECISION,
      "ID_OTHER"       SERIAL NOT NULL,
      "ORIGINAL"       BOOLEAN,
      "REPLANNING"     BOOLEAN,
      "TARGET_ID"      INTEGER,
      "TARGET_TYPE"    CHARACTER VARYING(255),
      "VERSION"        BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOEXTENSION_LINK" (
      "AOEXTENDABLE_ID"   INTEGER,
      "AOEXTENDABLE_TYPE" CHARACTER VARYING(127),
      "EXTENSION_KEY"     CHARACTER VARYING(255),
      "EXTENSION_LINK"    CHARACTER VARYING(255),
      "ID_OTHER"          SERIAL NOT NULL,
      "VERSION"           BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AONON_WORKING_DAYS" (
      "AOPLAN_ID"              INTEGER,
      "DESCRIPTION"            CHARACTER VARYING(255),
      "DETAILS"                TEXT,
      "END_DATE"               BIGINT,
      "ID_OTHER"               SERIAL NOT NULL,
      "ORDER_RANGE_IDENTIFIER" CHARACTER VARYING(255),
      "SORT_ORDER"             BIGINT,
      "START_DATE"             BIGINT,
      "TITLE"                  CHARACTER VARYING(255),
      "VERSION"                BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOPERMISSION" (
      "HOLDER_ID"   CHARACTER VARYING(255),
      "HOLDER_TYPE" CHARACTER VARYING(255),
      "ID_OTHER"    SERIAL NOT NULL,
      "PERMISSION"  INTEGER,
      "TARGET_ID"   CHARACTER VARYING(255),
      "TARGET_TYPE" CHARACTER VARYING(255),
      "VERSION"     BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOPERSON" (
      "AOEXTERNAL_ID" CHARACTER VARYING(255),
      "AOPLAN_ID"     INTEGER,
      "DESCRIPTION"   CHARACTER VARYING(255),
      "DETAILS"       TEXT,
      "EXTERNAL"      BOOLEAN,
      "ID_OTHER"      SERIAL NOT NULL,
      "TITLE"         CHARACTER VARYING(255),
      "VERSION"       BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOPLAN" (
      "AODATE"             BIGINT,
      "AOREPLANNING_DATE"  BIGINT,
      "DESCRIPTION"        CHARACTER VARYING(255),
      "DETAILS"            TEXT,
      "ID_OTHER"           SERIAL NOT NULL,
      "IN_REPLANNING"      BOOLEAN,
      "IN_STREAM_MODE"     BOOLEAN,
      "PLAN_VERSION"       BIGINT,
      "REPLANNING_VERSION" BIGINT,
      "SCHEDULING_VERSION" BIGINT,
      "TITLE"              CHARACTER VARYING(255),
      "VERSION"            BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOPLAN_CONFIGURATION" (
      "AOPLAN_ID"               INTEGER,
      "AOPROGRESS_TRACKER_TYPE" CHARACTER VARYING(255),
      "AOWEEKDAY_CONFIG"        INTEGER,
      "BACKLOG_RECORD_LIMIT"    INTEGER,
      "DEFAULT_EPIC_ESTIMATE"   DOUBLE PRECISION,
      "DEFAULT_STORY_ESTIMATE"  DOUBLE PRECISION,
      "EPIC_SYNC_MODE"          CHARACTER VARYING(255),
      "GLOBAL_DEFAULT_VELOCITY" DOUBLE PRECISION,
      "GLOBAL_SPRINT_LENGTH"    INTEGER,
      "HAS_SPRINT_CONSTRAINT"   BOOLEAN,
      "HEURISTIC_THRESHOLD"     INTEGER,
      "HOURS_PER_DAY"           DOUBLE PRECISION,
      "ID_OTHER"                SERIAL NOT NULL,
      "IMPORT_LIMIT"            INTEGER,
      "INITIATIVE_SYNC_MODE"    CHARACTER VARYING(255),
      "LINKING_MODE"            CHARACTER VARYING(255),
      "MAX_RESOURCES_PER_STORY" BIGINT,
      "MIN_LOAD_UNSTR_EPICS"    BIGINT,
      "PLANNING_UNIT"           CHARACTER VARYING(255),
      "PROG_CMPLT_IF_RSLVD"     BOOLEAN,
      "PROG_DSPL_UNEST_RTIO"    BOOLEAN,
      "PROG_FIELD_NAME"         CHARACTER VARYING(255),
      "PROG_STRY_SUB_TASK_MODE" CHARACTER VARYING(255),
      "SPRINT_EXCEEDED_WARN"    BOOLEAN,
      "STORY_SYNC_MODE"         CHARACTER VARYING(255),
      "STRICT_STAGE_DIVISION"   BOOLEAN,
      "SUGGEST_REPL_ESTIMATES"  BOOLEAN,
      "SYNC_DESCRIPTION"        BOOLEAN,
      "SYNC_EPICS"              BOOLEAN,
      "SYNC_ESTIMATES"          BOOLEAN,
      "SYNC_INITIATIVES"        BOOLEAN,
      "SYNC_START_ENABLED"      BOOLEAN,
      "SYNC_STORIES"            BOOLEAN,
      "SYNC_SUMMARY"            BOOLEAN,
      "TEMPLATE_TYPE"           CHARACTER VARYING(255)
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOPRESENCE" (
      "AOPERSON_ID"            INTEGER,
      "DESCRIPTION"            CHARACTER VARYING(255),
      "DETAILS"                TEXT,
      "END_DATE"               BIGINT,
      "ID_OTHER"               SERIAL NOT NULL,
      "ORDER_RANGE_IDENTIFIER" CHARACTER VARYING(255),
      "SORT_ORDER"             BIGINT,
      "START_DATE"             BIGINT,
      "TITLE"                  CHARACTER VARYING(255),
      "VERSION"                BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AORELEASE" (
      "AODELTA_START_DATE"     BIGINT,
      "AOFIXED_END_DATE"       BIGINT,
      "AOFIXED_START_DATE"     BIGINT,
      "AOPLAN_ID"              INTEGER,
      "AOSTREAM_ID"            INTEGER,
      "DESCRIPTION"            CHARACTER VARYING(255),
      "DETAILS"                TEXT,
      "ID_OTHER"               SERIAL NOT NULL,
      "IS_LATER_RELEASE"       BOOLEAN,
      "ORDER_RANGE_IDENTIFIER" CHARACTER VARYING(255),
      "PRIMARY_VERSION"        CHARACTER VARYING(255),
      "SORT_ORDER"             BIGINT,
      "TITLE"                  CHARACTER VARYING(255),
      "VERSION"                BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOREPLANNING" (
      "ID_OTHER"     SERIAL NOT NULL,
      "TARGET_ID"    CHARACTER VARYING(255),
      "TARGET_TYPE"  CHARACTER VARYING(255),
      "WORK_ITEM_ID" INTEGER
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AORESOURCE" (
      "AOPERSON_ID"            INTEGER,
      "AOTEAM_ID"              INTEGER,
      "AVAILABILITY"           DOUBLE PRECISION,
      "ID_OTHER"               SERIAL NOT NULL,
      "ORDER_RANGE_IDENTIFIER" CHARACTER VARYING(255),
      "SORT_ORDER"             BIGINT,
      "VERSION"                BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOSKILL" (
      "AOSTAGE_ID"             INTEGER,
      "DESCRIPTION"            CHARACTER VARYING(255),
      "DETAILS"                TEXT,
      "ID_OTHER"               SERIAL NOT NULL,
      "ORDER_RANGE_IDENTIFIER" CHARACTER VARYING(255),
      "PERCENTAGE"             DOUBLE PRECISION,
      "SORT_ORDER"             BIGINT,
      "STAGE_ID"               CHARACTER VARYING(255),
      "TITLE"                  CHARACTER VARYING(255),
      "VERSION"                BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOSOLUTION_STORE" (
      "AOPLAN_ID"        INTEGER NOT NULL,
      "ID_OTHER"         SERIAL  NOT NULL,
      "SOLUTION"         TEXT    NOT NULL,
      "SOLUTION_VERSION" BIGINT  NOT NULL
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOSPRINT" (
      "AOTEAM_ID"              INTEGER,
      "DESCRIPTION"            CHARACTER VARYING(255),
      "DETAILS"                TEXT,
      "END_DATE"               BIGINT,
      "ID_OTHER"               SERIAL NOT NULL,
      "ORDER_RANGE_IDENTIFIER" CHARACTER VARYING(255),
      "SORT_ORDER"             BIGINT,
      "START_DATE"             BIGINT,
      "TITLE"                  CHARACTER VARYING(255),
      "VERSION"                BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOSTAGE" (
      "AOPLAN_ID"              INTEGER,
      "COLOR"                  CHARACTER VARYING(255),
      "DESCRIPTION"            CHARACTER VARYING(255),
      "DETAILS"                TEXT,
      "ID_OTHER"               SERIAL NOT NULL,
      "ORDER_RANGE_IDENTIFIER" CHARACTER VARYING(255),
      "PERCENTAGE"             DOUBLE PRECISION,
      "SORT_ORDER"             BIGINT,
      "TITLE"                  CHARACTER VARYING(255),
      "VERSION"                BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOSTREAM" (
      "AOPLAN_ID"              INTEGER,
      "COLOR"                  CHARACTER VARYING(255),
      "DESCRIPTION"            CHARACTER VARYING(255),
      "DETAILS"                TEXT,
      "DYNAMIC_START_STREAM"   BOOLEAN,
      "ID_OTHER"               SERIAL NOT NULL,
      "ORDER_RANGE_IDENTIFIER" CHARACTER VARYING(255),
      "SHORT_NAME"             CHARACTER VARYING(255),
      "SORT_ORDER"             BIGINT,
      "TITLE"                  CHARACTER VARYING(255),
      "VERSION"                BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOSTREAM_TO_TEAM" (
      "AOSTREAM_ID" INTEGER,
      "AOTEAM_ID"   INTEGER,
      "ID_OTHER"    SERIAL NOT NULL,
      "VERSION"     BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOTEAM" (
      "AOPLAN_ID"               INTEGER,
      "AUTO_ADJUST_TO_ABSENCES" BOOLEAN,
      "DESCRIPTION"             CHARACTER VARYING(255),
      "DETAILS"                 TEXT,
      "ID_OTHER"                SERIAL NOT NULL,
      "INCREMENTAL_ADJUSTMENT"  DOUBLE PRECISION,
      "ITERATION_START_TYPE"    CHARACTER VARYING(255),
      "ORDER_RANGE_IDENTIFIER"  CHARACTER VARYING(255),
      "PLANNING_MODE"           CHARACTER VARYING(255),
      "SORT_ORDER"              BIGINT,
      "TITLE"                   CHARACTER VARYING(255),
      "VELOCITY"                DOUBLE PRECISION,
      "VERSION"                 BIGINT,
      "WEEKS_PER_SPRINT"        INTEGER
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOTHEME" (
      "AOPLAN_ID"              INTEGER,
      "COLOR"                  CHARACTER VARYING(255),
      "DESCRIPTION"            CHARACTER VARYING(255),
      "DETAILS"                TEXT,
      "ID_OTHER"               SERIAL NOT NULL,
      "ORDER_RANGE_IDENTIFIER" CHARACTER VARYING(255),
      "PERCENTAGE"             DOUBLE PRECISION,
      "SORT_ORDER"             BIGINT,
      "TITLE"                  CHARACTER VARYING(255),
      "VERSION"                BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOWORK_ITEM" (
      "AOBUSINESS_VALUE"       DOUBLE PRECISION,
      "AOEARLIEST_START"       BIGINT,
      "AOPARENT_ID"            INTEGER,
      "AOPLAN_ID"              INTEGER,
      "AORELEASE_ID"           INTEGER,
      "AOSPRINT_ID"            INTEGER,
      "AOSTREAM_ID"            INTEGER,
      "AOTARGET_END"           BIGINT,
      "AOTARGET_START"         BIGINT,
      "AOTEAM_ID"              INTEGER,
      "AOTHEME_ID"             INTEGER,
      "DESCRIPTION"            CHARACTER VARYING(255),
      "DETAILS"                TEXT,
      "EARLIEST_START"         BIGINT,
      "HAS_ORIGINAL_ESTIMATES" BOOLEAN,
      "ID_OTHER"               SERIAL NOT NULL,
      "ORDER_RANGE_IDENTIFIER" CHARACTER VARYING(255),
      "PARENT_ID"              CHARACTER VARYING(255),
      "REPLANNING_STATUS"      INTEGER,
      "SORT_ORDER"             BIGINT,
      "STATUS"                 INTEGER,
      "TITLE"                  CHARACTER VARYING(255),
      "TYPE"                   INTEGER,
      "VERSION"                BIGINT
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;
  BEGIN
    CREATE TABLE "AO_A415DF_AOWORK_ITEM_TO_RES" (
      "AORESOURCE_ID"  INTEGER,
      "AOWORK_ITEM_ID" INTEGER,
      "ID_OTHER"       SERIAL NOT NULL,
      "REPLANNING"     BOOLEAN
    );
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOABILITY"
      ADD CONSTRAINT "AO_A415DF_AOABILITY_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOABSENCE"
      ADD CONSTRAINT "AO_A415DF_AOABSENCE_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOAVAILABILITY"
      ADD CONSTRAINT "AO_A415DF_AOAVAILABILITY_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOCONFIGURATION"
      ADD CONSTRAINT "AO_A415DF_AOCONFIGURATION_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOCUSTOM_WORDING"
      ADD CONSTRAINT "AO_A415DF_AOCUSTOM_WORDING_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AODEPENDENCY"
      ADD CONSTRAINT "AO_A415DF_AODEPENDENCY_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AODOOR_STOP"
      ADD CONSTRAINT "AO_A415DF_AODOOR_STOP_pkey" PRIMARY KEY ("ID");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOESTIMATE"
      ADD CONSTRAINT "AO_A415DF_AOESTIMATE_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOEXTENSION_LINK"
      ADD CONSTRAINT "AO_A415DF_AOEXTENSION_LINK_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AONON_WORKING_DAYS"
      ADD CONSTRAINT "AO_A415DF_AONON_WORKING_DAYS_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOPERMISSION"
      ADD CONSTRAINT "AO_A415DF_AOPERMISSION_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOPERSON"
      ADD CONSTRAINT "AO_A415DF_AOPERSON_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOPLAN_CONFIGURATION"
      ADD CONSTRAINT "AO_A415DF_AOPLAN_CONFIGURATION_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOPLAN"
      ADD CONSTRAINT "AO_A415DF_AOPLAN_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOPRESENCE"
      ADD CONSTRAINT "AO_A415DF_AOPRESENCE_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AORELEASE"
      ADD CONSTRAINT "AO_A415DF_AORELEASE_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOREPLANNING"
      ADD CONSTRAINT "AO_A415DF_AOREPLANNING_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AORESOURCE"
      ADD CONSTRAINT "AO_A415DF_AORESOURCE_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOSKILL"
      ADD CONSTRAINT "AO_A415DF_AOSKILL_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOSOLUTION_STORE"
      ADD CONSTRAINT "AO_A415DF_AOSOLUTION_STORE_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOSPRINT"
      ADD CONSTRAINT "AO_A415DF_AOSPRINT_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOSTAGE"
      ADD CONSTRAINT "AO_A415DF_AOSTAGE_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOSTREAM_TO_TEAM"
      ADD CONSTRAINT "AO_A415DF_AOSTREAM_TO_TEAM_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOSTREAM"
      ADD CONSTRAINT "AO_A415DF_AOSTREAM_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOTEAM"
      ADD CONSTRAINT "AO_A415DF_AOTEAM_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOTHEME"
      ADD CONSTRAINT "AO_A415DF_AOTHEME_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOWORK_ITEM_TO_RES"
      ADD CONSTRAINT "AO_A415DF_AOWORK_ITEM_TO_RES_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOWORK_ITEM"
      ADD CONSTRAINT "AO_A415DF_AOWORK_ITEM_pkey" PRIMARY KEY ("ID_OTHER");
    EXCEPTION WHEN invalid_table_definition
    THEN NULL;
  END;


  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOSOLUTION_STORE"
      ADD CONSTRAINT u_AO_A415DF_aosolut752937716 UNIQUE ("AOPLAN_ID");
    EXCEPTION WHEN duplicate_table or unique_violation
    THEN NULL;
  END;


  BEGIN
    CREATE INDEX index_AO_A415DF_aoa123789499
      ON "AO_A415DF_AOABSENCE" USING BTREE ("AOPERSON_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aoa274205782
      ON "AO_A415DF_AOAVAILABILITY" USING BTREE ("AORESOURCE_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aoa576235854
      ON "AO_A415DF_AOABILITY" USING BTREE ("AOPERSON_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aod1576645787
      ON "AO_A415DF_AODEPENDENCY" USING BTREE ("DEPENDENT");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aod780424464
      ON "AO_A415DF_AODEPENDENCY" USING BTREE ("DEPENDEE");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aoe1359587886
      ON "AO_A415DF_AOESTIMATE" USING BTREE ("AOWORK_ITEM_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aoe449475677
      ON "AO_A415DF_AOEXTENSION_LINK" USING BTREE ("AOEXTENDABLE_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aon1597382101
      ON "AO_A415DF_AONON_WORKING_DAYS" USING BTREE ("AOPLAN_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aop1188979497
      ON "AO_A415DF_AOPERSON" USING BTREE ("AOPLAN_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aop1246856669
      ON "AO_A415DF_AOPRESENCE" USING BTREE ("AOPERSON_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aop485454964
      ON "AO_A415DF_AOPLAN_CONFIGURATION" USING BTREE ("AOPLAN_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aop577302103
      ON "AO_A415DF_AOPERMISSION" USING BTREE ("TARGET_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aor1533730578
      ON "AO_A415DF_AORESOURCE" USING BTREE ("AOTEAM_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aor287939766
      ON "AO_A415DF_AORESOURCE" USING BTREE ("AOPERSON_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aor34455044
      ON "AO_A415DF_AORELEASE" USING BTREE ("AOSTREAM_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aor548036520
      ON "AO_A415DF_AOREPLANNING" USING BTREE ("WORK_ITEM_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aor752754629
      ON "AO_A415DF_AORELEASE" USING BTREE ("AOPLAN_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aos1271634950
      ON "AO_A415DF_AOSPRINT" USING BTREE ("AOTEAM_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aos495640191
      ON "AO_A415DF_AOSTREAM_TO_TEAM" USING BTREE ("AOSTREAM_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aos562466878
      ON "AO_A415DF_AOSTREAM_TO_TEAM" USING BTREE ("AOTEAM_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aos598285716
      ON "AO_A415DF_AOSTREAM" USING BTREE ("AOPLAN_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aos617973864
      ON "AO_A415DF_AOSKILL" USING BTREE ("AOSTAGE_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aos901500530
      ON "AO_A415DF_AOSTAGE" USING BTREE ("AOPLAN_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aot1876296753
      ON "AO_A415DF_AOTEAM" USING BTREE ("AOPLAN_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aot513294467
      ON "AO_A415DF_AOTHEME" USING BTREE ("AOPLAN_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aow1045989527
      ON "AO_A415DF_AOWORK_ITEM_TO_RES" USING BTREE ("AORESOURCE_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aow1085872694
      ON "AO_A415DF_AOWORK_ITEM" USING BTREE ("ORDER_RANGE_IDENTIFIER");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aow1276121741
      ON "AO_A415DF_AOWORK_ITEM" USING BTREE ("AOTHEME_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aow1337278188
      ON "AO_A415DF_AOWORK_ITEM" USING BTREE ("AOPARENT_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aow1728248629
      ON "AO_A415DF_AOWORK_ITEM" USING BTREE ("AOPLAN_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aow1977806428
      ON "AO_A415DF_AOWORK_ITEM" USING BTREE ("AOSPRINT_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aow2028612028
      ON "AO_A415DF_AOWORK_ITEM_TO_RES" USING BTREE ("AOWORK_ITEM_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aow221278351
      ON "AO_A415DF_AOWORK_ITEM" USING BTREE ("AORELEASE_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aow571736702
      ON "AO_A415DF_AOWORK_ITEM" USING BTREE ("AOSTREAM_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;

  BEGIN
    CREATE INDEX index_AO_A415DF_aow782862209
      ON "AO_A415DF_AOWORK_ITEM" USING BTREE ("AOTEAM_ID");
    EXCEPTION WHEN duplicate_table
    THEN NULL;
  END;


  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOABILITY"
      ADD CONSTRAINT fk_AO_A415DF_aoability_aoperson_id FOREIGN KEY ("AOPERSON_ID") REFERENCES "AO_A415DF_AOPERSON" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOABSENCE"
      ADD CONSTRAINT fk_AO_A415DF_aoabsence_aoperson_id FOREIGN KEY ("AOPERSON_ID") REFERENCES "AO_A415DF_AOPERSON" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOAVAILABILITY"
      ADD CONSTRAINT fk_AO_A415DF_aoavailability_aoresource_id FOREIGN KEY ("AORESOURCE_ID") REFERENCES "AO_A415DF_AORESOURCE" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOESTIMATE"
      ADD CONSTRAINT fk_AO_A415DF_aoestimate_aowork_item_id FOREIGN KEY ("AOWORK_ITEM_ID") REFERENCES "AO_A415DF_AOWORK_ITEM" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AONON_WORKING_DAYS"
      ADD CONSTRAINT fk_AO_A415DF_aonon_working_days_aoplan_id FOREIGN KEY ("AOPLAN_ID") REFERENCES "AO_A415DF_AOPLAN" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOPERSON"
      ADD CONSTRAINT fk_AO_A415DF_aoperson_aoplan_id FOREIGN KEY ("AOPLAN_ID") REFERENCES "AO_A415DF_AOPLAN" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOPLAN_CONFIGURATION"
      ADD CONSTRAINT fk_AO_A415DF_aoplan_configuration_aoplan_id FOREIGN KEY ("AOPLAN_ID") REFERENCES "AO_A415DF_AOPLAN" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOPRESENCE"
      ADD CONSTRAINT fk_AO_A415DF_aopresence_aoperson_id FOREIGN KEY ("AOPERSON_ID") REFERENCES "AO_A415DF_AOPERSON" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AORELEASE"
      ADD CONSTRAINT fk_AO_A415DF_aorelease_aoplan_id FOREIGN KEY ("AOPLAN_ID") REFERENCES "AO_A415DF_AOPLAN" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AORELEASE"
      ADD CONSTRAINT fk_AO_A415DF_aorelease_aostream_id FOREIGN KEY ("AOSTREAM_ID") REFERENCES "AO_A415DF_AOSTREAM" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOREPLANNING"
      ADD CONSTRAINT fk_AO_A415DF_aoreplanning_work_item_id FOREIGN KEY ("WORK_ITEM_ID") REFERENCES "AO_A415DF_AOWORK_ITEM" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AORESOURCE"
      ADD CONSTRAINT fk_AO_A415DF_aoresource_aoperson_id FOREIGN KEY ("AOPERSON_ID") REFERENCES "AO_A415DF_AOPERSON" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AORESOURCE"
      ADD CONSTRAINT fk_AO_A415DF_aoresource_aoteam_id FOREIGN KEY ("AOTEAM_ID") REFERENCES "AO_A415DF_AOTEAM" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOSKILL"
      ADD CONSTRAINT fk_AO_A415DF_aoskill_aostage_id FOREIGN KEY ("AOSTAGE_ID") REFERENCES "AO_A415DF_AOSTAGE" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOSPRINT"
      ADD CONSTRAINT fk_AO_A415DF_aosprint_aoteam_id FOREIGN KEY ("AOTEAM_ID") REFERENCES "AO_A415DF_AOTEAM" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOSTAGE"
      ADD CONSTRAINT fk_AO_A415DF_aostage_aoplan_id FOREIGN KEY ("AOPLAN_ID") REFERENCES "AO_A415DF_AOPLAN" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOSTREAM"
      ADD CONSTRAINT fk_AO_A415DF_aostream_aoplan_id FOREIGN KEY ("AOPLAN_ID") REFERENCES "AO_A415DF_AOPLAN" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOSTREAM_TO_TEAM"
      ADD CONSTRAINT fk_AO_A415DF_aostream_to_team_aostream_id FOREIGN KEY ("AOSTREAM_ID") REFERENCES "AO_A415DF_AOSTREAM" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOSTREAM_TO_TEAM"
      ADD CONSTRAINT fk_AO_A415DF_aostream_to_team_aoteam_id FOREIGN KEY ("AOTEAM_ID") REFERENCES "AO_A415DF_AOTEAM" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOTEAM"
      ADD CONSTRAINT fk_AO_A415DF_aoteam_aoplan_id FOREIGN KEY ("AOPLAN_ID") REFERENCES "AO_A415DF_AOPLAN" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOTHEME"
      ADD CONSTRAINT fk_AO_A415DF_aotheme_aoplan_id FOREIGN KEY ("AOPLAN_ID") REFERENCES "AO_A415DF_AOPLAN" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOWORK_ITEM"
      ADD CONSTRAINT fk_AO_A415DF_aowork_item_aoparent_id FOREIGN KEY ("AOPARENT_ID") REFERENCES "AO_A415DF_AOWORK_ITEM" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOWORK_ITEM"
      ADD CONSTRAINT fk_AO_A415DF_aowork_item_aoplan_id FOREIGN KEY ("AOPLAN_ID") REFERENCES "AO_A415DF_AOPLAN" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOWORK_ITEM"
      ADD CONSTRAINT fk_AO_A415DF_aowork_item_aorelease_id FOREIGN KEY ("AORELEASE_ID") REFERENCES "AO_A415DF_AORELEASE" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOWORK_ITEM"
      ADD CONSTRAINT fk_AO_A415DF_aowork_item_aosprint_id FOREIGN KEY ("AOSPRINT_ID") REFERENCES "AO_A415DF_AOSPRINT" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOWORK_ITEM"
      ADD CONSTRAINT fk_AO_A415DF_aowork_item_aostream_id FOREIGN KEY ("AOSTREAM_ID") REFERENCES "AO_A415DF_AOSTREAM" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOWORK_ITEM"
      ADD CONSTRAINT fk_AO_A415DF_aowork_item_aoteam_id FOREIGN KEY ("AOTEAM_ID") REFERENCES "AO_A415DF_AOTEAM" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOWORK_ITEM"
      ADD CONSTRAINT fk_AO_A415DF_aowork_item_aotheme_id FOREIGN KEY ("AOTHEME_ID") REFERENCES "AO_A415DF_AOTHEME" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOWORK_ITEM_TO_RES"
      ADD CONSTRAINT fk_AO_A415DF_aowork_item_to_res_aoresource_id FOREIGN KEY ("AORESOURCE_ID") REFERENCES "AO_A415DF_AORESOURCE" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  BEGIN
    ALTER TABLE ONLY "AO_A415DF_AOWORK_ITEM_TO_RES"
      ADD CONSTRAINT fk_AO_A415DF_aowork_item_to_res_aowork_item_id FOREIGN KEY ("AOWORK_ITEM_ID") REFERENCES "AO_A415DF_AOWORK_ITEM" ("ID_OTHER");
    EXCEPTION WHEN duplicate_object OR foreign_key_violation
    THEN NULL;
  END;

  RETURN NULL;
END$$ LANGUAGE plpgsql;

SELECT create_ao_schema();

DROP FUNCTION create_ao_schema();