/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.lifecycle;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.lifecycle.PluginProvisioningTaskServiceBridge;
import com.atlassian.rm.common.bridges.jira.lifecycle.ProvisioningTask;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.lifecycle.PluginProvisioningTaskServiceBridge812")
@SupportedVersions(all=true)
class PluginProvisioningTaskServiceBridge812
implements PluginProvisioningTaskServiceBridge {
    private static final Log LOGGER = Log.with(PluginProvisioningTaskServiceBridge812.class);
    private List<ProvisioningTask> tasks = Lists.newArrayList();

    PluginProvisioningTaskServiceBridge812() {
    }

    @Override
    public void tryTriggerProvisioningTasks() {
        LOGGER.debug("triggered provisioning task execution", new Object[0]);
        for (ProvisioningTask task : this.tasks) {
            try {
                LOGGER.debug("Executing provisioning task '%s'...", task.getDisplayName());
                task.execute();
                LOGGER.info("provisioning task '%s' finished.", task.getDisplayName());
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error during task '%s'.", task.getDisplayName());
                LOGGER.exception(ex, Log.LogLevel.ERROR);
            }
        }
    }

    @Override
    public void setProvisioningTasks(List<ProvisioningTask> provisioningTasks) {
        this.tasks = provisioningTasks;
    }
}

