/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.querydsl;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ClosePromise
implements Closeable {
    private static final Runnable NOOP_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private boolean closed = false;
    private final ClosePromise parentPromise;
    private final Runnable closeEffect;

    public static ClosePromise NOOP() {
        return new ClosePromise();
    }

    public ClosePromise() {
        this(null, NOOP_RUNNABLE);
    }

    public ClosePromise(Runnable closeEffect) {
        this(ClosePromise.NOOP(), closeEffect);
    }

    public ClosePromise(ClosePromise parentPromise, Runnable closeEffect) {
        this.parentPromise = parentPromise;
        this.closeEffect = (Runnable)Preconditions.checkNotNull((Object)closeEffect);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.closeEffect();
        }
        if (this.parentPromise != null) {
            this.parentPromise.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void closeEffect() {
        this.closeEffect.run();
    }
}

