/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.issue.IssueAssignmentException;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridge;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridge812")
@SupportedVersions(all=true)
public class IssueServiceBridge812
implements IssueServiceBridge {
    private static final String CANNOT_GET_ISSUE_KEY = "issue.service.issue.wasdeleted";
    private static final String CANNOT_UPDATE_ISSUE_KEY = "issue.service.update.issue.is.null";
    private static final String CANNOT_DELETE_ISSUE_KEY = "issue.service.delete.issue.is.null";
    private static final String CANNOT_TRANSITION_ISSUE_KEY = "issue.service.transition.issue.is.null";
    private final IssueService issueService;
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public IssueServiceBridge812(IssueService issueService, PermissionManager permissionManager, I18nHelper.BeanFactory i18nFactory) {
        this.issueService = issueService;
        this.permissionManager = permissionManager;
        this.i18nFactory = i18nFactory;
    }

    @Override
    public IssueService.IssueResult getIssue(ApplicationUser user, String issueKey) {
        IssueService.IssueResult validationResult = this.issueService.getIssue(user, issueKey);
        return this.checkIssueIsNotArchived(validationResult, (MutableIssue issue, T result) -> new IssueService.IssueResult(issue, this.createErrorMessage(user, CANNOT_GET_ISSUE_KEY, ErrorCollection.Reason.NOT_FOUND)));
    }

    @Override
    public IssueService.IssueResult getIssue(@Nullable ApplicationUser user, Long issueId) {
        IssueService.IssueResult validationResult = this.issueService.getIssue(user, issueId);
        return this.checkIssueIsNotArchived(validationResult, (MutableIssue issue, T result) -> new IssueService.IssueResult(issue, this.createErrorMessage(user, CANNOT_GET_ISSUE_KEY, ErrorCollection.Reason.NOT_FOUND)));
    }

    @Override
    public IssueService.CreateValidationResult validateCreate(ApplicationUser user, IssueInputParameters issueInputParameters) {
        IssueService.CreateValidationResult validationResult = this.issueService.validateCreate(user, issueInputParameters);
        return this.checkAdditionalPermissions(user, issueInputParameters, validationResult);
    }

    @Override
    public IssueService.IssueResult create(ApplicationUser user, IssueService.CreateValidationResult createValidationResult) {
        return this.issueService.create(user, createValidationResult);
    }

    @Override
    public IssueService.DeleteValidationResult validateDelete(ApplicationUser user, Long issueId) {
        IssueService.DeleteValidationResult validationResult = this.issueService.validateDelete(user, issueId);
        return this.checkIssueIsNotArchived(validationResult, (MutableIssue issue, T result) -> new IssueService.DeleteValidationResult(issue, this.createErrorMessage(user, CANNOT_DELETE_ISSUE_KEY)));
    }

    @Override
    public ErrorCollection delete(@Nullable ApplicationUser user, IssueService.DeleteValidationResult deleteValidationResult) {
        return this.issueService.delete(user, deleteValidationResult);
    }

    @Override
    public IssueService.UpdateValidationResult validateUpdate(ApplicationUser user, Long issueId, IssueInputParameters issueInputParameters) {
        IssueService.UpdateValidationResult validationResult = this.issueService.validateUpdate(user, issueId, issueInputParameters);
        validationResult = this.checkIssueIsNotArchived(validationResult, (MutableIssue issue, T result) -> new IssueService.UpdateValidationResult(issue, this.createErrorMessage(user, CANNOT_UPDATE_ISSUE_KEY), result.getFieldValuesHolder()));
        return this.checkAdditionalPermissions(user, issueInputParameters, validationResult);
    }

    @Override
    public IssueService.IssueResult update(ApplicationUser user, IssueService.UpdateValidationResult updateValidationResult) {
        return this.issueService.update(user, updateValidationResult);
    }

    @Override
    public IssueService.TransitionValidationResult validateTransition(ApplicationUser user, Long issueId, int actionId, IssueInputParameters issueInputParameters) {
        IssueService.TransitionValidationResult validationResult = this.issueService.validateTransition(user, issueId, actionId, issueInputParameters);
        return this.checkIssueIsNotArchived(validationResult, user);
    }

    private IssueService.TransitionValidationResult checkIssueIsNotArchived(IssueService.TransitionValidationResult result, ApplicationUser user) {
        MutableIssue issue;
        if (result.isValid() && (issue = result.getIssue()).isArchived()) {
            result = new IssueService.TransitionValidationResult(null, this.createErrorMessage(user, CANNOT_TRANSITION_ISSUE_KEY), result.getFieldValuesHolder(), result.getAdditionInputs(), result.getActionId());
        }
        return result;
    }

    @Override
    public IssueService.IssueResult transition(ApplicationUser user, IssueService.TransitionValidationResult transitionValidationResult) {
        return this.issueService.transition(user, transitionValidationResult);
    }

    @Override
    public IssueService.CreateValidationResult validateSubTaskCreate(ApplicationUser reporter, Long parentId, IssueInputParameters issueInputParameters) {
        return this.issueService.validateSubTaskCreate(reporter, parentId, issueInputParameters);
    }

    @Override
    public IssueInputParameters newIssueInputParameters() {
        return this.issueService.newIssueInputParameters();
    }

    @Override
    public IssueInputParameters newIssueInputParameters(Map<String, String[]> params) {
        return this.issueService.newIssueInputParameters(params);
    }

    @Override
    public void setAssignee(ApplicationUser user, long issueId, String assigneeId) throws IssueAssignmentException {
        IssueService.AssignValidationResult validationResult = this.issueService.validateAssign(user, Long.valueOf(issueId), assigneeId);
        this.checkIssueIsNotArchivedForSetAssignee(validationResult);
        if (validationResult.isValid()) {
            IssueService.IssueResult result = this.issueService.assign(user, validationResult);
            if (!result.isValid()) {
                throw new IssueAssignmentException(result.getErrorCollection());
            }
        } else {
            throw new IssueAssignmentException(validationResult.getErrorCollection());
        }
    }

    private <T extends IssueService.IssueValidationResult> T checkAdditionalPermissions(ApplicationUser user, IssueInputParameters inputParameters, T validationResult) {
        if (inputParameters.getFixVersionIds() != null && !validationResult.getErrorCollection().hasAnyErrors() && !this.permissionManager.hasPermission(ProjectPermissions.RESOLVE_ISSUES, (Issue)validationResult.getIssue(), user)) {
            validationResult.getErrorCollection().addError("fixVersions", "Resolve issue permissions required to set fix version.");
        }
        return validationResult;
    }

    private <T extends IssueService.IssueValidationResult> T checkIssueIsNotArchived(T result, BiFunction<MutableIssue, T, T> constructor) {
        MutableIssue issue;
        if (result.isValid() && (issue = result.getIssue()).isArchived()) {
            result = (IssueService.IssueValidationResult)constructor.apply(null, result);
        }
        return result;
    }

    private <T extends IssueService.IssueValidationResult> void checkIssueIsNotArchivedForSetAssignee(T result) {
        MutableIssue issue;
        if (result.isValid() && (issue = result.getIssue()).isArchived()) {
            throw new NullPointerException("Issue is archived: " + issue.getKey());
        }
    }

    private ErrorCollection createErrorMessage(ApplicationUser user, String messageKey, ErrorCollection.Reason reason) {
        ErrorCollection errors = this.createErrorMessage(user, messageKey);
        errors.addReason(reason);
        return errors;
    }

    private ErrorCollection createErrorMessage(ApplicationUser user, String messageKey) {
        I18nHelper i18n = this.getI18n(user);
        String message = i18n.getText(messageKey);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addErrorMessage(message);
        return errors;
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }
}

