/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue.properties;

import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.issue.properties.IssuePropertyServiceBridge;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import io.atlassian.fugue.Option;
import java.util.function.BiFunction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.properties.IssuePropertyServiceBridge812")
@SupportedVersions(all=true)
public class IssuePropertyServiceBridge812
implements IssuePropertyServiceBridge {
    private static final String ISSUE_DOES_NOT_EXIST_KEY = "jira.properties.service.entity.does.not.exist";
    private final JiraAuthenticationContext authenticationContext;
    private final IssuePropertyService issuePropertyService;
    private final IssueManager issueManager;
    private final I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public IssuePropertyServiceBridge812(JiraAuthenticationContext authenticationContext, IssuePropertyService issuePropertyService, IssueManager issueManager, I18nHelper.BeanFactory i18nFactory) {
        this.authenticationContext = authenticationContext;
        this.issuePropertyService = issuePropertyService;
        this.issueManager = issueManager;
        this.i18nFactory = i18nFactory;
    }

    @Override
    public Optional<String> getProperty(long issueId, String propertyKey, boolean skipPermissionChecks) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        EntityPropertyService.PropertyResult propertyResult = skipPermissionChecks ? this.issuePropertyService.getProperty(user, Long.valueOf(issueId), propertyKey, this.skipPermissionChecks()) : this.issuePropertyService.getProperty(user, Long.valueOf(issueId), propertyKey);
        propertyResult = this.checkIssueIsNotArchived(propertyResult, user, issueId, EntityPropertyService.PropertyResult::new);
        return propertyResult.getEntityProperty().isEmpty() ? Optional.absent() : Optional.of((Object)((EntityProperty)propertyResult.getEntityProperty().get()).getValue());
    }

    @Override
    public void setProperty(long issueId, String propertyKey, String propertyValue, boolean skipPermissionChecks) {
        EntityPropertyService.SetPropertyValidationResult validationResult = this.validateSetProperty(issueId, propertyKey, propertyValue, skipPermissionChecks);
        this.issuePropertyService.setProperty(this.authenticationContext.getLoggedInUser(), validationResult);
    }

    @VisibleForTesting
    EntityPropertyService.SetPropertyValidationResult validateSetProperty(long issueId, String propertyKey, String propertyValue, boolean skipPermissionChecks) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        EntityPropertyService.PropertyInput propertyInput = new EntityPropertyService.PropertyInput(propertyValue, propertyKey);
        EntityPropertyService.SetPropertyValidationResult validationResult = skipPermissionChecks ? this.issuePropertyService.validateSetProperty(user, Long.valueOf(issueId), propertyInput, this.skipPermissionChecks()) : this.issuePropertyService.validateSetProperty(user, Long.valueOf(issueId), propertyInput);
        validationResult = this.checkIssueIsNotArchived(validationResult, user, issueId, EntityPropertyService.SetPropertyValidationResult::new);
        return validationResult;
    }

    private <T extends ServiceResultImpl> T checkIssueIsNotArchived(T result, ApplicationUser user, long issueId, BiFunction<ErrorCollection, Option, T> constructor) {
        if (result.isValid()) {
            MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(issueId));
            if (issue == null) {
                I18nHelper i18n = this.getI18n(user);
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                errorCollection.addErrorMessage(i18n.getText("issue.service.issue.wasdeleted"), ErrorCollection.Reason.NOT_FOUND);
                result = (ServiceResultImpl)constructor.apply((ErrorCollection)errorCollection, Option.none());
            } else if (issue.isArchived()) {
                I18nHelper i18n = this.getI18n(user);
                String entityType = i18n.getText(EntityPropertyType.ISSUE_PROPERTY.getI18nKeyForEntityName());
                String errorMessage = i18n.getText(ISSUE_DOES_NOT_EXIST_KEY, entityType);
                SimpleErrorCollection errors = new SimpleErrorCollection();
                errors.addErrorMessage(errorMessage, ErrorCollection.Reason.NOT_FOUND);
                result = (ServiceResultImpl)constructor.apply((ErrorCollection)errors, Option.none());
            }
        }
        return result;
    }

    @VisibleForTesting
    EntityPropertyOptions skipPermissionChecks() {
        return new EntityPropertyOptions.Builder().skipPermissionChecks().build();
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }
}

